/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.network.parser.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class ConversionUtil {
    public static String toIPV4(byte[] buffer, int offset, int length) {
        try {
            return InetAddress.getByAddress(Arrays.copyOfRange(buffer, offset, offset + length)).getHostAddress();
        }
        catch (UnknownHostException e) {
            return String.valueOf(ConversionUtil.toInt(buffer, offset, length));
        }
    }

    public static int toInt(byte[] buffer, int offset, int length) {
        int ret = 0;
        int done = offset + length;
        for (int i = offset; i < done; ++i) {
            ret = (ret << 8) + (buffer[i] & 0xFF);
        }
        return ret;
    }

    public static long toLong(byte[] buffer, int offset, int length) {
        long ret = 0L;
        int done = offset + length;
        for (int i = offset; i < done; ++i) {
            ret <<= 8;
            ret |= (long)(buffer[i] & 0xFF);
        }
        return ret;
    }

    public static short toShort(byte[] buffer, int offset, int length) {
        short ret = 0;
        int done = offset + length;
        for (int i = offset; i < done; ++i) {
            ret = (short)((ret << 8 & 0xFFFF) + (buffer[i] & 0xFF));
        }
        return ret;
    }
}

