/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar.provider;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.nar.provider.ClassLoaderInfoService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;

@Tags(value={"class-loader"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Gets ClassLoader info")
public class GetClassLoaderInfo
extends AbstractProcessor {
    public static final PropertyDescriptor CLASS_LOADER_INFO_SERVICE = new PropertyDescriptor.Builder().name("ClassLoader Info Service").description("Service for obtaining ClassLoader info").identifiesControllerService(ClassLoaderInfoService.class).required(true).build();
    public static final Relationship SUCCESS_RELATIONSHIP = new Relationship.Builder().name("success").description("Example relationship").build();
    private List<PropertyDescriptor> descriptors;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        this.descriptors = new ArrayList<PropertyDescriptor>();
        this.descriptors.add(CLASS_LOADER_INFO_SERVICE);
        this.descriptors = Collections.unmodifiableList(this.descriptors);
        this.relationships = new HashSet<Relationship>();
        this.relationships.add(SUCCESS_RELATIONSHIP);
        this.relationships = Collections.unmodifiableSet(this.relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        ClassLoaderInfoService classLoaderInfoService = (ClassLoaderInfoService)context.getProperty(CLASS_LOADER_INFO_SERVICE).asControllerService(ClassLoaderInfoService.class);
        String classLoaderInfo = classLoaderInfoService.getClassLoaderString();
        FlowFile flowFile = session.create();
        FlowFile writtenFlowFile = session.write(flowFile, out -> out.write(classLoaderInfo.getBytes(StandardCharsets.UTF_8)));
        session.transfer(writtenFlowFile, SUCCESS_RELATIONSHIP);
    }
}

