/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mqtt.common;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.mqtt.adapters.HiveMqV5ClientAdapter;
import org.apache.nifi.processors.mqtt.adapters.PahoMqttClientAdapter;
import org.apache.nifi.processors.mqtt.common.MqttClient;
import org.apache.nifi.processors.mqtt.common.MqttClientProperties;
import org.apache.nifi.processors.mqtt.common.MqttException;
import org.apache.nifi.processors.mqtt.common.MqttVersion;
import org.apache.nifi.security.util.TlsException;

public class MqttClientFactory {
    private final MqttClientProperties clientProperties;
    private final ComponentLog logger;
    private final RoundRobinList<URI> brokerUris;

    public MqttClientFactory(MqttClientProperties clientProperties, ComponentLog logger) {
        this.clientProperties = clientProperties;
        this.logger = logger;
        this.brokerUris = new RoundRobinList<URI>(clientProperties.getBrokerUris());
    }

    public MqttClient create() throws TlsException {
        return switch (this.clientProperties.getMqttVersion()) {
            case MqttVersion.MQTT_VERSION_3_AUTO, MqttVersion.MQTT_VERSION_3_1, MqttVersion.MQTT_VERSION_3_1_1 -> new PahoMqttClientAdapter(this.brokerUris.next(), this.clientProperties, this.logger);
            case MqttVersion.MQTT_VERSION_5_0 -> new HiveMqV5ClientAdapter(this.brokerUris.next(), this.clientProperties, this.logger);
            default -> throw new MqttException("Unsupported Mqtt version: " + String.valueOf((Object)this.clientProperties.getMqttVersion()));
        };
    }

    static class RoundRobinList<T> {
        private final List<T> list;
        private int index = 0;

        public RoundRobinList(List<T> list) {
            this.list = new ArrayList<T>(list);
        }

        public synchronized T next() {
            T next = this.list.get(this.index);
            this.index = this.index < this.list.size() - 1 ? ++this.index : 0;
            return next;
        }
    }
}

