/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.mongodb.MongoDBClientService;
import org.apache.nifi.ssl.SSLContextProvider;
import org.bson.Document;
import org.bson.conversions.Bson;

@Tags(value={"mongo", "mongodb", "service"})
@CapabilityDescription(value="Provides a controller service that configures a connection to MongoDB and provides access to that connection to other Mongo-related components.")
public class MongoDBControllerService
extends AbstractControllerService
implements MongoDBClientService {
    private String uri;
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(URI, DB_USER, DB_PASSWORD, SSL_CONTEXT_SERVICE, WRITE_CONCERN);
    protected MongoClient mongoClient;
    private String writeConcernProperty;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.uri = context.getProperty(URI).evaluateAttributeExpressions().getValue();
        this.mongoClient = this.createClient(context, this.mongoClient);
    }

    public void migrateProperties(PropertyConfiguration propertyConfiguration) {
        propertyConfiguration.removeProperty("ssl-client-auth");
        propertyConfiguration.renameProperty("mongo-uri", URI.getName());
        propertyConfiguration.renameProperty("ssl-context-service", SSL_CONTEXT_SERVICE.getName());
        propertyConfiguration.renameProperty("mongo-write-concern", WRITE_CONCERN.getName());
    }

    protected MongoClient createClient(ConfigurationContext context, MongoClient existing) {
        if (existing != null) {
            this.closeClient(existing);
        }
        this.writeConcernProperty = context.getProperty(WRITE_CONCERN).getValue();
        SSLContextProvider sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class);
        SSLContext sslContext = sslContextProvider == null ? null : sslContextProvider.createContext();
        try {
            String uri = context.getProperty(URI).evaluateAttributeExpressions().getValue();
            String user = context.getProperty(DB_USER).evaluateAttributeExpressions().getValue();
            String passw = context.getProperty(DB_PASSWORD).evaluateAttributeExpressions().getValue();
            MongoClientSettings.Builder builder = MongoClientSettings.builder();
            ConnectionString cs = new ConnectionString(uri);
            if (user != null && passw != null) {
                String database = cs.getDatabase() == null ? "admin" : cs.getDatabase();
                MongoCredential credential = MongoCredential.createCredential((String)user, (String)database, (char[])passw.toCharArray());
                builder.credential(credential);
            }
            if (sslContext != null) {
                builder.applyToSslSettings(sslBuilder -> sslBuilder.enabled(true).context(sslContext));
            }
            builder.applyConnectionString(cs);
            MongoClientSettings clientSettings = builder.build();
            return MongoClients.create((MongoClientSettings)clientSettings);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to schedule {} due to {}", new Object[]{((Object)((Object)this)).getClass().getName(), e, e});
            throw e;
        }
    }

    @OnStopped
    public final void onStopped() {
        this.closeClient(this.mongoClient);
    }

    private void closeClient(MongoClient client) {
        if (client != null) {
            client.close();
        }
    }

    public WriteConcern getWriteConcern() {
        WriteConcern writeConcern;
        switch (this.writeConcernProperty) {
            case "ACKNOWLEDGED": {
                writeConcern = WriteConcern.ACKNOWLEDGED;
                break;
            }
            case "UNACKNOWLEDGED": {
                writeConcern = WriteConcern.UNACKNOWLEDGED;
                break;
            }
            case "FSYNCED": {
                writeConcern = WriteConcern.JOURNALED;
                this.getLogger().warn("Using deprecated write concern FSYNCED");
                break;
            }
            case "JOURNALED": {
                writeConcern = WriteConcern.JOURNALED;
                break;
            }
            case "REPLICA_ACKNOWLEDGED": {
                writeConcern = WriteConcern.W2;
                this.getLogger().warn("Using deprecated write concern REPLICA_ACKNOWLEDGED");
                break;
            }
            case "MAJORITY": {
                writeConcern = WriteConcern.MAJORITY;
                break;
            }
            case "W1": {
                writeConcern = WriteConcern.W1;
                break;
            }
            case "W2": {
                writeConcern = WriteConcern.W2;
                break;
            }
            case "W3": {
                writeConcern = WriteConcern.W3;
                break;
            }
            default: {
                writeConcern = WriteConcern.ACKNOWLEDGED;
            }
        }
        return writeConcern;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnDisabled
    public void onDisable() {
        this.mongoClient.close();
    }

    public MongoDatabase getDatabase(String name) {
        return this.mongoClient.getDatabase(name);
    }

    public String getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        ConfigVerificationResult.Builder connectionSuccessful = new ConfigVerificationResult.Builder().verificationStepName("Connection test");
        MongoClient client = null;
        try {
            client = this.createClient(context, null);
            MongoDatabase db = client.getDatabase("test");
            db.runCommand((Bson)new Document("buildInfo", (Object)1));
            connectionSuccessful.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL);
        }
        catch (Exception ex) {
            connectionSuccessful.explanation(ex.getMessage()).outcome(ConfigVerificationResult.Outcome.FAILED);
        }
        finally {
            this.closeClient(client);
        }
        return List.of(connectionSuccessful.build());
    }
}

