/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;

public interface QueryHelper {
    public static final AllowableValue MODE_ONE_COMMIT = new AllowableValue("all-at-once", "Full Query Fetch", "Fetch the entire query result and then make it available to downstream processors.");
    public static final AllowableValue MODE_MANY_COMMITS = new AllowableValue("streaming", "Stream Query Results", "As soon as the query start sending results to the downstream processors at regular intervals.");
    public static final String OLD_OPERATION_MODE_PROPERTY_NAME = "mongo-operation-mode";
    public static final PropertyDescriptor OPERATION_MODE = new PropertyDescriptor.Builder().name("Operation Mode").allowableValues(new DescribedValue[]{MODE_ONE_COMMIT, MODE_MANY_COMMITS}).defaultValue(MODE_ONE_COMMIT.getValue()).required(true).description("This option controls when results are made available to downstream processors. If Stream Query Results is enabled, provenance will not be tracked relative to the input flowfile if an input flowfile is received and starts the query. In Stream Query Results mode errors will be handled by sending a new flowfile with the original content and attributes of the input flowfile to the failure relationship. Streaming should only be used if there is reliable connectivity between MongoDB and NiFi.").addValidator(Validator.VALID).build();

    default public String readQuery(ProcessContext context, ProcessSession session, PropertyDescriptor queryProp, FlowFile input) throws IOException {
        String queryStr;
        if (context.getProperty(queryProp).isSet()) {
            queryStr = context.getProperty(queryProp).evaluateAttributeExpressions(input).getValue();
        } else if (!context.getProperty(queryProp).isSet() && input == null) {
            queryStr = "{}";
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            session.exportTo(input, (OutputStream)out);
            out.close();
            queryStr = new String(out.toByteArray());
        }
        return queryStr;
    }
}

