/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb.gridfs;

import com.mongodb.client.MongoCursor;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.mongodb.MongoDBClientService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.mongodb.gridfs.AbstractGridFSProcessor;
import org.apache.nifi.util.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

@CapabilityDescription(value="Deletes a file from GridFS using a file name or a query.")
@Tags(value={"gridfs", "delete", "mongodb"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class DeleteGridFS
extends AbstractGridFSProcessor {
    static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("delete-gridfs-query").displayName("Query").description("A valid MongoDB query to use to find and delete one or more files from GridFS.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).required(false).build();
    static final PropertyDescriptor FILE_NAME = new PropertyDescriptor.Builder().name("gridfs-file-name").displayName("File Name").description("The name of the file in the bucket that is the target of this processor. GridFS file names do not include path information because GridFS does not sort files into folders within a bucket.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Stream.concat(DeleteGridFS.getCommonPropertyDescriptors().stream(), Stream.of(FILE_NAME, QUERY, QUERY_ATTRIBUTE)).toList();

    public Set<Relationship> getRelationships() {
        return DeleteGridFS.getCommonRelationships();
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        boolean fileName = validationContext.getProperty(FILE_NAME).isSet();
        boolean query = validationContext.getProperty(QUERY).isSet();
        if (fileName && query) {
            problems.add(new ValidationResult.Builder().valid(false).explanation("File name and Query cannot be set at the same time.").build());
        } else if (!fileName && !query) {
            problems.add(new ValidationResult.Builder().valid(false).explanation("File name or Query must be set, but not both at the same time.").build());
        }
        return problems;
    }

    private String getQuery(ProcessContext context, FlowFile input) {
        String queryString;
        if (context.getProperty(FILE_NAME).isSet()) {
            String fileName = context.getProperty(FILE_NAME).evaluateAttributeExpressions(input).getValue();
            queryString = String.format("{ \"filename\": \"%s\"}", fileName);
        } else {
            queryString = context.getProperty(QUERY).evaluateAttributeExpressions(input).getValue();
        }
        return queryString;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientService = (MongoDBClientService)context.getProperty(CLIENT_SERVICE).asControllerService(MongoDBClientService.class);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile input = session.get();
        if (input == null) {
            return;
        }
        String deleteQuery = this.getQuery(context, input);
        String queryAttribute = context.getProperty(QUERY_ATTRIBUTE).isSet() ? context.getProperty(QUERY_ATTRIBUTE).evaluateAttributeExpressions(input).getValue() : null;
        GridFSBucket bucket = this.getBucket(input, context);
        try {
            Document query = Document.parse((String)deleteQuery);
            MongoCursor cursor = bucket.find((Bson)query).iterator();
            if (cursor.hasNext()) {
                GridFSFile file = (GridFSFile)cursor.next();
                bucket.delete(file.getObjectId());
                if (!StringUtils.isEmpty((String)queryAttribute)) {
                    input = session.putAttribute(input, queryAttribute, deleteQuery);
                }
                session.transfer(input, REL_SUCCESS);
            } else {
                this.getLogger().error("Query {} did not delete anything in {}", new Object[]{deleteQuery, bucket.getBucketName()});
                session.transfer(input, REL_FAILURE);
            }
            cursor.close();
        }
        catch (Exception ex) {
            this.getLogger().error("Error deleting using query: {}", new Object[]{deleteQuery, ex});
            session.transfer(input, REL_FAILURE);
        }
    }
}

