/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.FlowFileValidator;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.PropertyMigrationResult;
import org.apache.nifi.util.RelationshipMigrationResult;

public interface TestRunner {
    public Processor getProcessor();

    public ProcessSessionFactory getProcessSessionFactory();

    public ProcessContext getProcessContext();

    public boolean isYieldCalled();

    public void run();

    public void run(int var1);

    public void run(int var1, boolean var2);

    public void run(int var1, boolean var2, boolean var3);

    public void run(int var1, boolean var2, boolean var3, long var4);

    public void unSchedule();

    public void stop();

    public void shutdown();

    public void setThreadCount(int var1);

    public int getThreadCount();

    public ValidationResult setProperty(String var1, String var2);

    public ValidationResult setProperty(PropertyDescriptor var1, String var2);

    public ValidationResult setProperty(PropertyDescriptor var1, DescribedValue var2);

    public void setAnnotationData(String var1);

    public void assertAllFlowFilesTransferred(String var1);

    public void assertAllFlowFilesTransferred(Relationship var1);

    public void assertAllFlowFilesTransferred(String var1, int var2);

    public void assertAllFlowFilesTransferred(Relationship var1, int var2);

    public void assertAllFlowFilesContainAttribute(String var1);

    public void assertAllFlowFilesContainAttribute(Relationship var1, String var2);

    public void assertAllFlowFiles(FlowFileValidator var1);

    public void assertAllFlowFiles(Relationship var1, FlowFileValidator var2);

    public void assertAttributes(Relationship var1, Set<String> var2, Set<Map<String, String>> var3);

    public void assertContents(Relationship var1, List<String> var2);

    public void assertTransferCount(Relationship var1, int var2);

    public void assertTransferCount(String var1, int var2);

    public void assertPenalizeCount(int var1);

    public void assertQueueEmpty();

    public boolean isQueueEmpty();

    public void assertQueueNotEmpty();

    public void assertValid();

    public boolean isValid();

    public void assertNotValid();

    public void clearTransferState();

    public void enqueue(FlowFile ... var1);

    public MockFlowFile enqueue(Path var1) throws IOException;

    public MockFlowFile enqueue(Path var1, Map<String, String> var2) throws IOException;

    public MockFlowFile enqueue(byte[] var1);

    public MockFlowFile enqueue(String var1);

    public MockFlowFile enqueue(byte[] var1, Map<String, String> var2);

    public MockFlowFile enqueue(String var1, Map<String, String> var2);

    public MockFlowFile enqueue(InputStream var1);

    public MockFlowFile enqueue(InputStream var1, Map<String, String> var2);

    public byte[] getContentAsByteArray(MockFlowFile var1);

    public List<MockFlowFile> getFlowFilesForRelationship(String var1);

    public List<MockFlowFile> getFlowFilesForRelationship(Relationship var1);

    public List<MockFlowFile> getPenalizedFlowFiles();

    public QueueSize getQueueSize();

    public void clearQueue();

    public Long getCounterValue(String var1);

    public int getRemovedCount();

    public void setRelationshipAvailable(Relationship var1);

    public void setRelationshipAvailable(String var1);

    public void setRelationshipUnavailable(Relationship var1);

    public void setRelationshipUnavailable(String var1);

    public void setIncomingConnection(boolean var1);

    public void setNonLoopConnection(boolean var1);

    public void addConnection(Relationship var1);

    public void addConnection(String var1);

    public void removeConnection(Relationship var1);

    public void removeConnection(String var1);

    public void addControllerService(String var1, ControllerService var2) throws InitializationException;

    public void addControllerService(String var1, ControllerService var2, Map<String, String> var3) throws InitializationException;

    public void enableControllerService(ControllerService var1);

    public void disableControllerService(ControllerService var1);

    public boolean isControllerServiceEnabled(ControllerService var1);

    public void removeControllerService(ControllerService var1);

    public ValidationResult setProperty(ControllerService var1, PropertyDescriptor var2, String var3);

    public ValidationResult setProperty(ControllerService var1, PropertyDescriptor var2, DescribedValue var3);

    public ValidationResult setProperty(ControllerService var1, String var2, String var3);

    public void setAnnotationData(ControllerService var1, String var2);

    public ControllerService getControllerService(String var1);

    public void assertValid(ControllerService var1);

    public void assertNotValid(ControllerService var1);

    public <T extends ControllerService> T getControllerService(String var1, Class<T> var2);

    public void setValidateExpressionUsage(boolean var1);

    public void setAllowSynchronousSessionCommits(boolean var1);

    public void setAllowRecursiveReads(boolean var1);

    public boolean removeProperty(PropertyDescriptor var1);

    public boolean removeProperty(ControllerService var1, PropertyDescriptor var2);

    public boolean removeProperty(String var1);

    public boolean removeProperty(ControllerService var1, String var2);

    public void clearProperties();

    public List<ProvenanceEventRecord> getProvenanceEvents();

    public void clearProvenanceEvents();

    public MockComponentLog getLogger();

    public MockComponentLog getControllerServiceLogger(String var1);

    public MockStateManager getStateManager();

    public MockStateManager getStateManager(ControllerService var1);

    public void setClustered(boolean var1);

    public void setIsConfiguredForClustering(boolean var1);

    public void setPrimaryNode(boolean var1);

    public void setConnected(boolean var1);

    public String getEnvironmentVariableValue(String var1);

    public void setEnvironmentVariableValue(String var1, String var2);

    public void assertAllConditionsMet(String var1, Predicate<MockFlowFile> var2);

    public void assertAllConditionsMet(Relationship var1, Predicate<MockFlowFile> var2);

    public void enforceReadStreamsClosed(boolean var1);

    public void setRunSchedule(long var1);

    public void assertProvenanceEvent(ProvenanceEventType var1);

    public PropertyMigrationResult migrateProperties();

    public RelationshipMigrationResult migrateRelationships();
}

