/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.kerberos.KerberosContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parameter.ParameterProviderInitializationContext;
import org.apache.nifi.util.MockControllerServiceLookup;

public class MockParameterProviderInitializationContext
extends MockControllerServiceLookup
implements ParameterProviderInitializationContext,
ControllerServiceLookup {
    private final String identifier;
    private final String name;
    private final Map<PropertyDescriptor, String> properties = new HashMap<PropertyDescriptor, String>();
    private final ComponentLog logger;
    private final KerberosContext kerberosContext;

    public MockParameterProviderInitializationContext(String identifier, String name, ComponentLog logger) {
        this(identifier, name, logger, null);
    }

    public MockParameterProviderInitializationContext(String identifier, String name, ComponentLog logger, KerberosContext kerberosContext) {
        this.identifier = identifier;
        this.name = name;
        this.logger = logger;
        this.kerberosContext = kerberosContext;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setProperty(String propertyName, String value) {
        this.setProperty(new PropertyDescriptor.Builder().name(propertyName).build(), value);
    }

    public void setProperty(PropertyDescriptor propertyName, String value) {
        this.properties.put(propertyName, value);
    }

    public void setProperties(Map<PropertyDescriptor, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return null;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public String getKerberosServicePrincipal() {
        return this.kerberosContext != null ? this.kerberosContext.getKerberosServicePrincipal() : null;
    }

    public File getKerberosServiceKeytab() {
        return this.kerberosContext != null ? this.kerberosContext.getKerberosServiceKeytab() : null;
    }

    public File getKerberosConfigurationFile() {
        return this.kerberosContext != null ? this.kerberosContext.getKerberosConfigurationFile() : null;
    }
}

