/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.lumberjack.handler;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.listen.dispatcher.AsyncChannelDispatcher;
import org.apache.nifi.processor.util.listen.event.Event;
import org.apache.nifi.processor.util.listen.event.EventFactory;
import org.apache.nifi.processor.util.listen.event.EventFactoryUtil;
import org.apache.nifi.processor.util.listen.event.EventQueue;
import org.apache.nifi.processor.util.listen.response.ChannelResponder;
import org.apache.nifi.processors.lumberjack.frame.LumberjackEncoder;
import org.apache.nifi.processors.lumberjack.frame.LumberjackFrame;

@Deprecated
public class LumberjackFrameHandler<E extends Event<SocketChannel>> {
    private final Charset charset;
    private final EventFactory<E> eventFactory;
    private final EventQueue<E> events;
    private final SelectionKey key;
    private final AsyncChannelDispatcher dispatcher;
    private final LumberjackEncoder encoder;
    private final ComponentLog logger;

    public LumberjackFrameHandler(SelectionKey selectionKey, Charset charset, EventFactory<E> eventFactory, BlockingQueue<E> events, AsyncChannelDispatcher dispatcher, ComponentLog logger) {
        this.key = selectionKey;
        this.charset = charset;
        this.eventFactory = eventFactory;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.events = new EventQueue(events, logger);
        this.encoder = new LumberjackEncoder();
    }

    public void handle(LumberjackFrame frame, ChannelResponder<SocketChannel> responder, String sender) throws IOException, InterruptedException {
        Map metadata = EventFactoryUtil.createMapWithSender((String)sender.toString());
        metadata.put("lumberjack.sequencenumber", String.valueOf(frame.getSeqNumber()));
        String line = "";
        if (frame.getFrameType() == 68) {
            ByteBuffer currentData = ByteBuffer.wrap(frame.getPayload());
            long pairCount = (long)currentData.getInt() & 0xFFFFFFFFL;
            HashMap<String, String> fields = new HashMap<String, String>();
            int i = 0;
            while ((long)i < pairCount) {
                long keyLength = (long)currentData.getInt() & 0xFFFFFFFFL;
                byte[] bytes = new byte[(int)keyLength];
                currentData.get(bytes);
                String key = new String(bytes);
                long valueLength = (long)currentData.getInt() & 0xFFFFFFFFL;
                bytes = new byte[(int)valueLength];
                currentData.get(bytes);
                String value = new String(bytes);
                if (key.equals("line")) {
                    line = value;
                } else {
                    fields.put(key, value);
                }
                ++i;
            }
            Gson serialFields = new Gson();
            metadata.put("lumberjack.fields", serialFields.toJson(fields).toString());
            Event event = this.eventFactory.create(line.getBytes(), metadata, responder);
            this.events.offer(event);
        } else if (frame.getFrameType() == 74) {
            this.logger.error("Data type was JSON. JSON payload aren't yet supported, pending the documentation of Lumberjack protocol v2");
        }
    }
}

