/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.lumberjack.frame;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.apache.nifi.processors.lumberjack.frame.LumberjackFrame;
import org.apache.nifi.processors.lumberjack.frame.LumberjackFrameException;
import org.apache.nifi.processors.lumberjack.frame.LumberjackState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LumberjackDecoder {
    static final Logger logger = LoggerFactory.getLogger(LumberjackDecoder.class);
    private LumberjackFrame.Builder frameBuilder;
    private LumberjackState currState = LumberjackState.VERSION;
    private byte decodedFrameType;
    private byte[] decompressedData;
    private final Charset charset;
    private final ByteArrayOutputStream currBytes;
    private long windowSize;
    public static final byte FRAME_WINDOWSIZE = 87;
    public static final byte FRAME_DATA = 68;
    public static final byte FRAME_COMPRESSED = 67;
    public static final byte FRAME_ACK = 65;
    public static final byte FRAME_JSON = 74;

    public LumberjackDecoder(Charset charset) {
        this(charset, new ByteArrayOutputStream(4096));
    }

    public LumberjackDecoder(Charset charset, ByteArrayOutputStream buffer) {
        this.charset = charset;
        this.currBytes = buffer;
        this.frameBuilder = new LumberjackFrame.Builder();
        this.decodedFrameType = 0;
    }

    public void reset() {
        this.frameBuilder = new LumberjackFrame.Builder();
        this.currState = LumberjackState.VERSION;
        this.decodedFrameType = 0;
        this.currBytes.reset();
    }

    public boolean process(byte currByte) throws LumberjackFrameException {
        try {
            switch (this.currState) {
                case VERSION: {
                    this.processVERSION(currByte);
                    break;
                }
                case FRAMETYPE: {
                    this.processFRAMETYPE(currByte);
                    break;
                }
                case PAYLOAD: {
                    this.processPAYLOAD(currByte);
                    if (this.frameBuilder.frameType == 87 && this.currState == LumberjackState.COMPLETE) {
                        return true;
                    }
                    if (this.frameBuilder.frameType != 67 || this.currState != LumberjackState.COMPLETE) break;
                    return true;
                }
                case COMPLETE: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new LumberjackFrameException("Error decoding Lumberjack frame: " + e.getMessage(), e);
        }
    }

    public List<LumberjackFrame> getFrames() throws LumberjackFrameException {
        List<LumberjackFrame> frames = new LinkedList<LumberjackFrame>();
        if (this.currState != LumberjackState.COMPLETE) {
            throw new LumberjackFrameException("Must be at the trailer of a frame");
        }
        try {
            if (this.currState == LumberjackState.COMPLETE && this.frameBuilder.frameType == 67) {
                logger.debug("Frame is compressed, will iterate to decode", new Object[0]);
                this.currBytes.reset();
                this.frameBuilder.reset();
                this.currState = LumberjackState.VERSION;
                frames = this.processDECOMPRESSED(this.decompressedData);
            } else {
                LumberjackFrame frame = this.frameBuilder.build();
                this.currBytes.reset();
                this.frameBuilder.reset();
                this.currState = LumberjackState.VERSION;
                frames.add(frame);
            }
            return frames;
        }
        catch (Exception e) {
            throw new LumberjackFrameException("Error decoding Lumberjack frame: " + e.getMessage(), e);
        }
    }

    private List<LumberjackFrame> processDECOMPRESSED(byte[] decompressedData) {
        LinkedList<LumberjackFrame> frames = new LinkedList<LumberjackFrame>();
        LumberjackFrame.Builder internalFrameBuilder = new LumberjackFrame.Builder();
        ByteBuffer currentData = ByteBuffer.wrap(decompressedData);
        while (currentData.hasRemaining()) {
            int payloadLength = 0;
            internalFrameBuilder.version = currentData.get();
            internalFrameBuilder.frameType = currentData.get();
            internalFrameBuilder.seqNumber = (long)currentData.getInt() & 0xFFFFFFFFL;
            currentData.mark();
            payloadLength -= currentData.position();
            long pairCount = (long)currentData.getInt() & 0xFFFFFFFFL;
            int i = 0;
            while ((long)i < pairCount) {
                long keyLength = (long)currentData.getInt() & 0xFFFFFFFFL;
                currentData.position(currentData.position() + (int)keyLength);
                long valueLength = (long)currentData.getInt() & 0xFFFFFFFFL;
                currentData.position(currentData.position() + (int)valueLength);
                ++i;
            }
            currentData.reset();
            byte[] bytes = new byte[payloadLength += currentData.position()];
            currentData.get(bytes, 0, payloadLength);
            currentData.mark();
            internalFrameBuilder.payload(bytes);
            LumberjackFrame frame = internalFrameBuilder.build();
            frames.add(frame);
            internalFrameBuilder.reset();
        }
        return frames;
    }

    private void processVERSION(byte b) {
        byte version = b;
        this.frameBuilder.version(version);
        logger.debug("Version number is {}", new Object[]{version});
        this.currBytes.write(b);
        this.currState = LumberjackState.FRAMETYPE;
    }

    private void processFRAMETYPE(byte b) {
        this.decodedFrameType = b;
        this.frameBuilder.frameType(this.decodedFrameType);
        logger.debug("Frame type is {}", new Object[]{this.decodedFrameType});
        this.currBytes.write(b);
        this.currState = LumberjackState.PAYLOAD;
    }

    private void processPAYLOAD(byte b) {
        this.currBytes.write(b);
        switch (this.decodedFrameType) {
            case 87: {
                if (this.currBytes.size() < 6) {
                    logger.trace("Lumberjack currBytes contents are {}", (Object)this.currBytes.toString());
                    break;
                }
                if (this.currBytes.size() != 6) break;
                this.frameBuilder.dataSize = (long)ByteBuffer.wrap(Arrays.copyOfRange(this.currBytes.toByteArray(), 2, 6)).getInt() & 0xFFFFFFFFL;
                logger.debug("Data size is {}", new Object[]{this.frameBuilder.dataSize});
                this.frameBuilder.payload(new byte[0]);
                this.currBytes.reset();
                this.currState = LumberjackState.COMPLETE;
                this.windowSize = this.frameBuilder.dataSize;
                break;
            }
            case 67: {
                if (this.currBytes.size() < 6) {
                    logger.trace("Lumberjack currBytes contents are {}", (Object)this.currBytes.toString());
                    break;
                }
                if (this.currBytes.size() < 6) break;
                this.frameBuilder.dataSize = (long)ByteBuffer.wrap(Arrays.copyOfRange(this.currBytes.toByteArray(), 2, 6)).getInt() & 0xFFFFFFFFL;
                if ((long)(this.currBytes.size() - 6) != this.frameBuilder.dataSize) break;
                try {
                    int len;
                    byte[] buf = Arrays.copyOfRange(this.currBytes.toByteArray(), 6, this.currBytes.size());
                    InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(buf));
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((len = ((InputStream)in).read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    ((InputStream)in).close();
                    out.close();
                    this.decompressedData = out.toByteArray();
                    buf = null;
                    logger.debug("Finished decompressing data");
                    this.frameBuilder.dataSize(this.decompressedData.length);
                    this.currState = LumberjackState.COMPLETE;
                    break;
                }
                catch (IOException e) {
                    throw new LumberjackFrameException("Error decompressing  frame: " + e.getMessage(), e);
                }
            }
        }
    }

    private void processCOMPLETE() {
        this.currBytes.reset();
        this.frameBuilder.reset();
        this.currState = LumberjackState.VERSION;
    }
}

