/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ldap.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.nifi.authentication.exception.ProviderCreationException;
import org.apache.nifi.ldap.ProviderProperty;
import org.apache.nifi.ldap.ssl.LdapSslContextProvider;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardLdapSslContextProvider
implements LdapSslContextProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardLdapSslContextProvider.class);
    private static final String DEFAULT_PROTOCOL = "TLS";

    @Override
    public SSLContext createContext(Map<String, String> properties) {
        Objects.requireNonNull(properties, "Properties required");
        String rawProtocol = properties.get(ProviderProperty.TLS_PROTOCOL.getProperty());
        String protocol = rawProtocol == null || rawProtocol.isBlank() ? DEFAULT_PROTOCOL : rawProtocol;
        try {
            StandardSslContextBuilder sslContextBuilder = new StandardSslContextBuilder();
            sslContextBuilder.protocol(protocol);
            KeyStore trustStore = this.getTrustStore(properties);
            if (trustStore == null) {
                logger.debug("LDAP TLS Truststore not configured");
            } else {
                sslContextBuilder.trustStore(trustStore);
            }
            KeyStore keyStore = this.getKeyStore(properties);
            if (keyStore == null) {
                logger.debug("LDAP TLS Keystore not configured");
            } else {
                String keyStorePassword = properties.get(ProviderProperty.KEYSTORE_PASSWORD.getProperty());
                char[] keyPassword = keyStorePassword.toCharArray();
                sslContextBuilder.keyStore(keyStore);
                sslContextBuilder.keyPassword(keyPassword);
            }
            SSLContext sslContext = sslContextBuilder.build();
            return sslContext;
        }
        catch (Exception e) {
            throw new ProviderCreationException("Error configuring TLS for LDAP Provider", (Throwable)e);
        }
    }

    private KeyStore getKeyStore(Map<String, String> properties) throws IOException {
        KeyStore keyStore;
        String rawKeystore = properties.get(ProviderProperty.KEYSTORE.getProperty());
        String rawKeystorePassword = properties.get(ProviderProperty.KEYSTORE_PASSWORD.getProperty());
        String rawKeystoreType = properties.get(ProviderProperty.KEYSTORE_TYPE.getProperty());
        if (rawKeystore == null || rawKeystore.isBlank()) {
            keyStore = null;
        } else {
            if (rawKeystorePassword == null) {
                throw new ProviderCreationException("Keystore Password not configured");
            }
            StandardKeyStoreBuilder builder = new StandardKeyStoreBuilder();
            builder.type(rawKeystoreType);
            char[] keyStorePassword = rawKeystorePassword.toCharArray();
            builder.password(keyStorePassword);
            Path trustStorePath = Paths.get(rawKeystore, new String[0]);
            try (InputStream trustStoreStream = Files.newInputStream(trustStorePath, new OpenOption[0]);){
                builder.inputStream(trustStoreStream);
                keyStore = builder.build();
            }
        }
        return keyStore;
    }

    private KeyStore getTrustStore(Map<String, String> properties) throws IOException {
        KeyStore trustStore;
        String rawTruststore = properties.get(ProviderProperty.TRUSTSTORE.getProperty());
        String rawTruststorePassword = properties.get(ProviderProperty.TRUSTSTORE_PASSWORD.getProperty());
        String rawTruststoreType = properties.get(ProviderProperty.TRUSTSTORE_TYPE.getProperty());
        if (rawTruststore == null || rawTruststore.isBlank()) {
            trustStore = null;
        } else {
            if (rawTruststorePassword == null) {
                throw new ProviderCreationException("Truststore Password not configured");
            }
            StandardKeyStoreBuilder builder = new StandardKeyStoreBuilder();
            builder.type(rawTruststoreType);
            char[] trustStorePassword = rawTruststorePassword.toCharArray();
            builder.password(trustStorePassword);
            Path trustStorePath = Paths.get(rawTruststore, new String[0]);
            try (InputStream trustStoreStream = Files.newInputStream(trustStorePath, new OpenOption[0]);){
                builder.inputStream(trustStoreStream);
                trustStore = builder.build();
            }
        }
        return trustStore;
    }
}

