/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ldap;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authentication.LoginCredentials;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authentication.LoginIdentityProviderConfigurationContext;
import org.apache.nifi.authentication.LoginIdentityProviderInitializationContext;
import org.apache.nifi.authentication.exception.IdentityAccessException;
import org.apache.nifi.authentication.exception.InvalidLoginCredentialsException;
import org.apache.nifi.authentication.exception.ProviderCreationException;
import org.apache.nifi.authentication.exception.ProviderDestructionException;
import org.apache.nifi.configuration.NonComponentConfigurationContext;
import org.apache.nifi.ldap.IdentityStrategy;
import org.apache.nifi.ldap.LdapAuthenticationStrategy;
import org.apache.nifi.ldap.LdapsSocketFactory;
import org.apache.nifi.ldap.ReferralStrategy;
import org.apache.nifi.ldap.ssl.StandardLdapSslContextProvider;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.DefaultTlsDirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.core.support.SimpleDirContextAuthenticationStrategy;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapUserDetails;

public class LdapProvider
implements LoginIdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(LdapProvider.class);
    private AbstractLdapAuthenticationProvider provider;
    private String issuer;
    private long expiration;
    private IdentityStrategy identityStrategy;

    public final void initialize(LoginIdentityProviderInitializationContext initializationContext) throws ProviderCreationException {
        this.issuer = this.getClass().getSimpleName();
    }

    public final void onConfigured(LoginIdentityProviderConfigurationContext configurationContext) throws ProviderCreationException {
        ReferralStrategy referralStrategy;
        LdapAuthenticationStrategy authenticationStrategy;
        String rawExpiration = configurationContext.getProperty("Authentication Expiration");
        if (StringUtils.isBlank((CharSequence)rawExpiration)) {
            throw new ProviderCreationException("The Authentication Expiration must be specified.");
        }
        try {
            this.expiration = FormatUtils.getTimeDuration((String)rawExpiration, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (IllegalArgumentException iae) {
            throw new ProviderCreationException(String.format("The Expiration Duration '%s' is not a valid time duration", rawExpiration));
        }
        LdapContextSource context = new LdapContextSource();
        HashMap<String, Object> baseEnvironment = new HashMap<String, Object>();
        this.setTimeout(configurationContext, baseEnvironment, "Connect Timeout", "com.sun.jndi.ldap.connect.timeout");
        this.setTimeout(configurationContext, baseEnvironment, "Read Timeout", "com.sun.jndi.ldap.read.timeout");
        String rawAuthenticationStrategy = configurationContext.getProperty("Authentication Strategy");
        try {
            authenticationStrategy = LdapAuthenticationStrategy.valueOf(rawAuthenticationStrategy);
        }
        catch (IllegalArgumentException iae) {
            throw new ProviderCreationException(String.format("Unrecognized authentication strategy '%s'. Possible values are [%s]", rawAuthenticationStrategy, StringUtils.join((Object[])LdapAuthenticationStrategy.values(), (String)", ")));
        }
        block5 : switch (authenticationStrategy) {
            case ANONYMOUS: {
                context.setAnonymousReadOnly(true);
                break;
            }
            default: {
                String userDn = configurationContext.getProperty("Manager DN");
                String password = configurationContext.getProperty("Manager Password");
                context.setUserDn(userDn);
                context.setPassword(password);
                switch (authenticationStrategy) {
                    case SIMPLE: {
                        context.setAuthenticationStrategy((DirContextAuthenticationStrategy)new SimpleDirContextAuthenticationStrategy());
                        break block5;
                    }
                    case LDAPS: {
                        context.setAuthenticationStrategy((DirContextAuthenticationStrategy)new SimpleDirContextAuthenticationStrategy());
                        baseEnvironment.put("java.naming.security.protocol", "ssl");
                        SSLContext ldapsSslContext = LdapProvider.getConfiguredSslContext((NonComponentConfigurationContext)configurationContext);
                        if (ldapsSslContext == null) break block5;
                        LdapsSocketFactory.initialize(ldapsSslContext.getSocketFactory());
                        baseEnvironment.put("java.naming.ldap.factory.socket", LdapsSocketFactory.class.getName());
                        break block5;
                    }
                    case START_TLS: {
                        SSLContext startTlsSslContext;
                        DefaultTlsDirContextAuthenticationStrategy tlsAuthenticationStrategy = new DefaultTlsDirContextAuthenticationStrategy();
                        String rawShutdownGracefully = configurationContext.getProperty("TLS - Shutdown Gracefully");
                        if (StringUtils.isNotBlank((CharSequence)rawShutdownGracefully)) {
                            boolean shutdownGracefully = Boolean.TRUE.toString().equalsIgnoreCase(rawShutdownGracefully);
                            tlsAuthenticationStrategy.setShutdownTlsGracefully(shutdownGracefully);
                        }
                        if ((startTlsSslContext = LdapProvider.getConfiguredSslContext((NonComponentConfigurationContext)configurationContext)) != null) {
                            tlsAuthenticationStrategy.setSslSocketFactory(startTlsSslContext.getSocketFactory());
                        }
                        context.setAuthenticationStrategy((DirContextAuthenticationStrategy)tlsAuthenticationStrategy);
                    }
                }
            }
        }
        String rawReferralStrategy = configurationContext.getProperty("Referral Strategy");
        try {
            referralStrategy = ReferralStrategy.valueOf(rawReferralStrategy);
        }
        catch (IllegalArgumentException iae) {
            throw new ProviderCreationException(String.format("Unrecognized referral strategy '%s'. Possible values are [%s]", rawReferralStrategy, StringUtils.join((Object[])ReferralStrategy.values(), (String)", ")));
        }
        context.setReferral(referralStrategy.getValue());
        String urls = configurationContext.getProperty("Url");
        if (StringUtils.isBlank((CharSequence)urls)) {
            throw new ProviderCreationException("LDAP identity provider 'Url' must be specified.");
        }
        context.setUrls(StringUtils.split((String)urls));
        String userSearchBase = configurationContext.getProperty("User Search Base");
        String userSearchFilter = configurationContext.getProperty("User Search Filter");
        if (StringUtils.isBlank((CharSequence)userSearchBase) || StringUtils.isBlank((CharSequence)userSearchFilter)) {
            throw new ProviderCreationException("LDAP identity provider 'User Search Base' and 'User Search Filter' must be specified.");
        }
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(userSearchBase, userSearchFilter, (BaseLdapPathContextSource)context);
        BindAuthenticator authenticator = new BindAuthenticator((BaseLdapPathContextSource)context);
        authenticator.setUserSearch((LdapUserSearch)userSearch);
        String rawIdentityStrategy = configurationContext.getProperty("Identity Strategy");
        if (StringUtils.isBlank((CharSequence)rawIdentityStrategy)) {
            logger.info("Identity Strategy is not configured, defaulting strategy to {}.", (Object)IdentityStrategy.USE_DN);
            this.identityStrategy = IdentityStrategy.USE_DN;
        } else {
            try {
                this.identityStrategy = IdentityStrategy.valueOf(rawIdentityStrategy);
            }
            catch (IllegalArgumentException iae) {
                throw new ProviderCreationException(String.format("Unrecognized identity strategy '%s'. Possible values are [%s]", rawIdentityStrategy, StringUtils.join((Object[])IdentityStrategy.values(), (String)", ")));
            }
        }
        if (!baseEnvironment.isEmpty()) {
            context.setBaseEnvironmentProperties(baseEnvironment);
        }
        try {
            context.afterPropertiesSet();
            authenticator.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new ProviderCreationException(e.getMessage(), (Throwable)e);
        }
        this.provider = new LdapAuthenticationProvider((LdapAuthenticator)authenticator);
    }

    private void setTimeout(LoginIdentityProviderConfigurationContext configurationContext, Map<String, Object> baseEnvironment, String configurationProperty, String environmentKey) {
        String rawTimeout = configurationContext.getProperty(configurationProperty);
        if (StringUtils.isNotBlank((CharSequence)rawTimeout)) {
            try {
                long timeout = (long)FormatUtils.getPreciseTimeDuration((String)rawTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
                baseEnvironment.put(environmentKey, String.valueOf(timeout));
            }
            catch (IllegalArgumentException iae) {
                throw new ProviderCreationException(String.format("The %s '%s' is not a valid time duration", configurationProperty, rawTimeout));
            }
        }
    }

    private static SSLContext getConfiguredSslContext(NonComponentConfigurationContext configurationContext) {
        StandardLdapSslContextProvider ldapSslContextProvider = new StandardLdapSslContextProvider();
        Map contextProperties = configurationContext.getProperties();
        return ldapSslContextProvider.createContext(contextProperties);
    }

    public final AuthenticationResponse authenticate(LoginCredentials credentials) throws InvalidLoginCredentialsException, IdentityAccessException {
        if (this.provider == null) {
            throw new IdentityAccessException("The LDAP authentication provider is not initialized.");
        }
        try {
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)credentials.getUsername(), (Object)credentials.getPassword());
            Authentication authentication = this.provider.authenticate((Authentication)token);
            if (IdentityStrategy.USE_DN.equals((Object)this.identityStrategy)) {
                Object object = authentication.getPrincipal();
                if (object instanceof LdapUserDetails) {
                    LdapUserDetails userDetails = (LdapUserDetails)object;
                    return new AuthenticationResponse(userDetails.getDn(), credentials.getUsername(), this.expiration, this.issuer);
                }
                logger.warn("Unable to determine user DN for {}, using username.", (Object)authentication.getName());
                return new AuthenticationResponse(authentication.getName(), credentials.getUsername(), this.expiration, this.issuer);
            }
            return new AuthenticationResponse(authentication.getName(), credentials.getUsername(), this.expiration, this.issuer);
        }
        catch (AuthenticationException | BadCredentialsException | UsernameNotFoundException e) {
            throw new InvalidLoginCredentialsException(e.getMessage(), e);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof AuthenticationException) {
                throw new InvalidLoginCredentialsException(e.getMessage(), (Throwable)e);
            }
            logger.error(e.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("", (Throwable)e);
            }
            throw new IdentityAccessException("Unable to validate the supplied credentials. Please contact the system administrator.", (Throwable)e);
        }
    }

    public final void preDestruction() throws ProviderDestructionException {
    }
}

