/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kerberos;

import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.AbstractKerberosUserService;
import org.apache.nifi.kerberos.SelfContainedKerberosUserService;
import org.apache.nifi.security.krb.KerberosTicketCacheUser;
import org.apache.nifi.security.krb.KerberosUser;

@CapabilityDescription(value="Provides a mechanism for creating a KerberosUser from a principal and ticket cache that other components are able to use in order to perform authentication using Kerberos. By encapsulating this information into a Controller Service and allowing other components to make use of it an administrator is able to choose which users are allowed to use which ticket caches and principals. This provides a more robust security model for multi-tenant use cases.")
@Tags(value={"Kerberos", "Ticket", "Cache", "Principal", "Credentials", "Authentication", "Security"})
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.ACCESS_TICKET_CACHE, explanation="Allows user to define a ticket cache and principal that can then be used by other components.")})
public class KerberosTicketCacheUserService
extends AbstractKerberosUserService
implements SelfContainedKerberosUserService {
    static final PropertyDescriptor TICKET_CACHE_FILE = new PropertyDescriptor.Builder().name("Kerberos Ticket Cache File").description("Kerberos ticket cache associated with the principal.").identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).build();
    private volatile String ticketCacheFile;

    @Override
    protected List<PropertyDescriptor> getAdditionalProperties() {
        return Collections.singletonList(TICKET_CACHE_FILE);
    }

    @Override
    protected void setAdditionalConfiguredValues(ConfigurationContext context) {
        this.ticketCacheFile = context.getProperty(TICKET_CACHE_FILE).evaluateAttributeExpressions().getValue();
    }

    public KerberosUser createKerberosUser() {
        return new KerberosTicketCacheUser(this.getPrincipal(), this.ticketCacheFile);
    }
}

