/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import javax.security.auth.login.AppConfigurationEntry;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.LoginConfigBuilder;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;
import org.apache.nifi.kafka.shared.property.AwsRoleSource;
import org.apache.nifi.util.StringUtils;

public class AwsMskIamLoginConfigProvider
implements LoginConfigProvider {
    private static final String MODULE_CLASS = "software.amazon.msk.auth.iam.IAMLoginModule";
    private static final String AWS_PROFILE_NAME_KEY = "awsProfileName";
    private static final String ROLE_ARN_KEY = "awsRoleArn";
    private static final String ROLE_SESSION_NAME_KEY = "awsRoleSessionName";

    @Override
    public String getConfiguration(PropertyContext context) {
        String awsProfileName;
        AwsRoleSource roleSource = (AwsRoleSource)context.getProperty(KafkaClientComponent.AWS_ROLE_SOURCE).asAllowableValue(AwsRoleSource.class);
        LoginConfigBuilder builder = new LoginConfigBuilder(MODULE_CLASS, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED);
        if (roleSource == AwsRoleSource.SPECIFIED_PROFILE && !StringUtils.isBlank((String)(awsProfileName = context.getProperty(KafkaClientComponent.AWS_PROFILE_NAME).getValue()))) {
            builder.append(AWS_PROFILE_NAME_KEY, awsProfileName);
        }
        if (roleSource == AwsRoleSource.SPECIFIED_ROLE) {
            String assumeRoleArn = context.getProperty(KafkaClientComponent.AWS_ASSUME_ROLE_ARN).getValue();
            String assumeRoleSessionName = context.getProperty(KafkaClientComponent.AWS_ASSUME_ROLE_SESSION_NAME).getValue();
            builder.append(ROLE_ARN_KEY, assumeRoleArn);
            builder.append(ROLE_SESSION_NAME_KEY, assumeRoleSessionName);
        }
        return builder.build();
    }
}

