/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.property.KafkaClientProperty;
import org.apache.nifi.kafka.shared.property.SaslMechanism;
import org.apache.nifi.kafka.shared.property.SecurityProtocol;
import org.apache.nifi.kafka.shared.property.provider.StandardKafkaPropertyProvider;
import org.apache.nifi.kerberos.KerberosUserService;

public class KafkaClientCustomValidationFunction
implements Function<ValidationContext, Collection<ValidationResult>> {
    static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private static final String JNDI_LOGIN_MODULE_CLASS = "JndiLoginModule";
    private static final String JND_LOGIN_MODULE_EXPLANATION = "The JndiLoginModule is not allowed in the JAAS configuration";
    private static final List<SaslMechanism> USERNAME_PASSWORD_SASL_MECHANISMS = Arrays.asList(SaslMechanism.PLAIN, SaslMechanism.SCRAM_SHA_256, SaslMechanism.SCRAM_SHA_512);
    private static final List<String> SASL_PROTOCOLS = Arrays.asList(SecurityProtocol.SASL_PLAINTEXT.name(), SecurityProtocol.SASL_SSL.name());

    @Override
    public Collection<ValidationResult> apply(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        this.validateLoginModule(validationContext, results);
        this.validateKerberosCredentials(validationContext, results);
        this.validateUsernamePassword(validationContext, results);
        this.validateAwsMskIamMechanism(validationContext, results);
        return results;
    }

    private void validateLoginModule(ValidationContext validationContext, Collection<ValidationResult> results) {
        PropertyDescriptor propertyDescriptor2;
        String saslJaasConfig;
        Optional<PropertyDescriptor> propertyDescriptorFound = validationContext.getProperties().keySet().stream().filter(propertyDescriptor -> KafkaClientProperty.SASL_JAAS_CONFIG.getProperty().equals(propertyDescriptor.getName())).findFirst();
        if (propertyDescriptorFound.isPresent() && (saslJaasConfig = validationContext.getProperty(propertyDescriptor2 = propertyDescriptorFound.get()).getValue()).contains(JNDI_LOGIN_MODULE_CLASS)) {
            results.add(new ValidationResult.Builder().subject(propertyDescriptor2.getName()).valid(false).explanation(JND_LOGIN_MODULE_EXPLANATION).build());
        }
    }

    private void validateKerberosCredentials(ValidationContext validationContext, Collection<ValidationResult> results) {
        SaslMechanism saslMechanism = (SaslMechanism)validationContext.getProperty(KafkaClientComponent.SASL_MECHANISM).asAllowableValue(SaslMechanism.class);
        String securityProtocol = validationContext.getProperty(KafkaClientComponent.SECURITY_PROTOCOL).getValue();
        if (saslMechanism == SaslMechanism.GSSAPI && SASL_PROTOCOLS.contains(securityProtocol)) {
            String serviceName = validationContext.getProperty(KafkaClientComponent.KERBEROS_SERVICE_NAME).evaluateAttributeExpressions().getValue();
            if (this.isEmpty(serviceName)) {
                String explanation = String.format("[%s] required for [%s] value [%s]", new Object[]{KafkaClientComponent.KERBEROS_SERVICE_NAME.getDisplayName(), KafkaClientComponent.SASL_MECHANISM.getDisplayName(), SaslMechanism.GSSAPI});
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.KERBEROS_SERVICE_NAME.getDisplayName()).valid(false).explanation(explanation).build());
            }
            String systemLoginConfig = System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
            KerberosUserService userService = (KerberosUserService)validationContext.getProperty(KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
            if (userService == null && this.isEmpty(systemLoginConfig)) {
                String explanation = String.format("Kerberos Credentials not found in component properties or System Property [%s]", JAVA_SECURITY_AUTH_LOGIN_CONFIG);
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.SASL_MECHANISM.getDisplayName()).valid(false).explanation(explanation).build());
            }
        }
    }

    private void validateUsernamePassword(ValidationContext validationContext, Collection<ValidationResult> results) {
        SaslMechanism saslMechanism = (SaslMechanism)validationContext.getProperty(KafkaClientComponent.SASL_MECHANISM).asAllowableValue(SaslMechanism.class);
        if (USERNAME_PASSWORD_SASL_MECHANISMS.contains((Object)saslMechanism)) {
            String password;
            String username = validationContext.getProperty(KafkaClientComponent.SASL_USERNAME).evaluateAttributeExpressions().getValue();
            if (username == null || username.isEmpty()) {
                String explanation = String.format("[%s] required for [%s] values: %s", KafkaClientComponent.SASL_USERNAME.getDisplayName(), KafkaClientComponent.SASL_MECHANISM.getDisplayName(), USERNAME_PASSWORD_SASL_MECHANISMS);
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.SASL_USERNAME.getDisplayName()).valid(false).explanation(explanation).build());
            }
            if ((password = validationContext.getProperty(KafkaClientComponent.SASL_PASSWORD).evaluateAttributeExpressions().getValue()) == null || password.isEmpty()) {
                String explanation = String.format("[%s] required for [%s] values: %s", KafkaClientComponent.SASL_PASSWORD.getDisplayName(), KafkaClientComponent.SASL_MECHANISM.getDisplayName(), USERNAME_PASSWORD_SASL_MECHANISMS);
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.SASL_PASSWORD.getDisplayName()).valid(false).explanation(explanation).build());
            }
        }
    }

    private void validateAwsMskIamMechanism(ValidationContext validationContext, Collection<ValidationResult> results) {
        SaslMechanism saslMechanism;
        PropertyValue saslMechanismProperty = validationContext.getProperty(KafkaClientComponent.SASL_MECHANISM);
        if (saslMechanismProperty.isSet() && (saslMechanism = (SaslMechanism)saslMechanismProperty.asAllowableValue(SaslMechanism.class)) == SaslMechanism.AWS_MSK_IAM && !StandardKafkaPropertyProvider.isAwsMskIamCallbackHandlerFound()) {
            String explanation = String.format("[%s] required class not found: Kafka modules must be compiled with AWS MSK enabled", "software.amazon.msk.auth.iam.IAMClientCallbackHandler");
            results.add(new ValidationResult.Builder().subject(KafkaClientComponent.SASL_MECHANISM.getDisplayName()).valid(false).explanation(explanation).build());
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

