/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.util;

import java.util.function.Supplier;

public class Notifier {
    private final Object object = new Object();

    public boolean waitForCondition(Supplier<Boolean> conditionComplete, long timeout) {
        boolean isInterrupted = false;
        long millisTimeout = System.currentTimeMillis() + timeout;
        Supplier<Boolean> conditionTimeout = () -> System.currentTimeMillis() >= millisTimeout;
        while (!(conditionComplete.get().booleanValue() || conditionTimeout.get().booleanValue() || isInterrupted)) {
            isInterrupted = this.waitUntil(millisTimeout);
        }
        return conditionComplete.get();
    }

    private boolean waitUntil(long millisTimeout) {
        boolean interrupted = false;
        long millisNow = System.currentTimeMillis();
        if (millisNow < millisTimeout) {
            interrupted = this.waitFor(millisTimeout - millisNow);
        }
        return interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitFor(long millis) {
        boolean interrupted = false;
        Object object = this.object;
        synchronized (object) {
            try {
                this.object.wait(millis);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        return interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWaiter() {
        Object object = this.object;
        synchronized (object) {
            this.object.notify();
        }
    }
}

