/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import java.util.Map;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.AwsMskIamLoginConfigProvider;
import org.apache.nifi.kafka.shared.login.KerberosDelegatingLoginConfigProvider;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;
import org.apache.nifi.kafka.shared.login.PlainLoginConfigProvider;
import org.apache.nifi.kafka.shared.login.ScramLoginConfigProvider;
import org.apache.nifi.kafka.shared.property.SaslMechanism;

public class DelegatingLoginConfigProvider
implements LoginConfigProvider {
    private static final LoginConfigProvider SCRAM_PROVIDER = new ScramLoginConfigProvider();
    private static final Map<SaslMechanism, LoginConfigProvider> PROVIDERS = Map.of(SaslMechanism.GSSAPI, new KerberosDelegatingLoginConfigProvider(), SaslMechanism.PLAIN, new PlainLoginConfigProvider(), SaslMechanism.SCRAM_SHA_256, SCRAM_PROVIDER, SaslMechanism.SCRAM_SHA_512, SCRAM_PROVIDER, SaslMechanism.AWS_MSK_IAM, new AwsMskIamLoginConfigProvider());

    @Override
    public String getConfiguration(PropertyContext context) {
        SaslMechanism saslMechanism = (SaslMechanism)context.getProperty(KafkaClientComponent.SASL_MECHANISM).asAllowableValue(SaslMechanism.class);
        LoginConfigProvider loginConfigProvider = PROVIDERS.getOrDefault((Object)saslMechanism, SCRAM_PROVIDER);
        return loginConfigProvider.getConfiguration(context);
    }
}

