/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.service.security;

import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.ClientJwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.exception.ProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthBearerLoginCallbackHandler.class);
    public static final String PROPERTY_KEY_NIFI_OAUTH_2_ACCESS_TOKEN_PROVIDER = "nifi.oauth2.access.token.provider";
    private OAuth2AccessTokenProvider accessTokenProvider;
    private ClientJwtValidator accessTokenValidator;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        Map options = JaasOptionsUtils.getOptions((String)saslMechanism, jaasConfigEntries);
        String serviceId = (String)options.get("serviceId");
        if (serviceId == null) {
            throw new ProcessException(String.format("JAAS configuration must contain %s. [%s]", "serviceId", options));
        }
        Object service = configs.get(PROPERTY_KEY_NIFI_OAUTH_2_ACCESS_TOKEN_PROVIDER);
        if (!(service instanceof OAuth2AccessTokenProvider)) {
            throw new ProcessException(String.format("OAuth2AccessTokenProvider must be provided via %s property in Kafka configuration", PROPERTY_KEY_NIFI_OAUTH_2_ACCESS_TOKEN_PROVIDER));
        }
        OAuth2AccessTokenProvider accessTokenProvider = (OAuth2AccessTokenProvider)service;
        if (!accessTokenProvider.getIdentifier().equals(serviceId)) {
            throw new ProcessException(String.format("OAuth2AccessTokenProvider's identifier [%s] does not mach %s [%s] in JAAS configuration", accessTokenProvider.getIdentifier(), "serviceId", serviceId));
        }
        this.accessTokenProvider = accessTokenProvider;
        this.accessTokenValidator = new ClientJwtValidator();
        this.accessTokenValidator.configure(configs, saslMechanism, List.of());
    }

    public void handle(Callback[] callbacks) {
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerTokenCallback)) continue;
            this.handleTokenCallback((OAuthBearerTokenCallback)callback);
        }
    }

    private void handleTokenCallback(OAuthBearerTokenCallback callback) {
        String accessToken;
        try {
            accessToken = this.accessTokenProvider.getAccessDetails().getAccessToken();
        }
        catch (Exception e) {
            LOGGER.error("Could not retrieve access token", (Throwable)e);
            callback.error("service_error", e.getMessage(), null);
            return;
        }
        try {
            OAuthBearerToken token = this.accessTokenValidator.validate(accessToken);
            callback.token(token);
        }
        catch (JwtValidatorException e) {
            LOGGER.error("Could not validate and parse access token", (Throwable)e);
            callback.error("invalid_token", e.getMessage(), null);
        }
    }

    public void close() {
    }
}

