/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.service.consumer;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.nifi.kafka.service.api.consumer.AutoOffsetReset;

public class Subscription {
    private final String groupId;
    private final Collection<String> topics;
    private final Pattern topicPattern;
    private final AutoOffsetReset autoOffsetReset;

    public Subscription(String groupId, Collection<String> topics, AutoOffsetReset autoOffsetReset) {
        this.groupId = Objects.requireNonNull(groupId, "Group ID required");
        this.topics = Collections.unmodifiableCollection(Objects.requireNonNull(topics, "Topics required"));
        this.topicPattern = null;
        this.autoOffsetReset = Objects.requireNonNull(autoOffsetReset, "Auto Offset Reset required");
    }

    public Subscription(String groupId, Pattern topicPattern, AutoOffsetReset autoOffsetReset) {
        this.groupId = Objects.requireNonNull(groupId, "Group ID required");
        this.topics = Collections.emptyList();
        this.topicPattern = Objects.requireNonNull(topicPattern, "Topic Pattern required");
        this.autoOffsetReset = Objects.requireNonNull(autoOffsetReset, "Auto Offset Reset required");
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Collection<String> getTopics() {
        return this.topics;
    }

    public Optional<Pattern> getTopicPattern() {
        return Optional.ofNullable(this.topicPattern);
    }

    public AutoOffsetReset getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Subscription) {
            Subscription subscription = (Subscription)object;
            return this.groupId.equals(subscription.groupId) && this.isTopicSubscriptionMatched(subscription) && this.autoOffsetReset == subscription.autoOffsetReset;
        }
        return false;
    }

    public int hashCode() {
        return this.groupId.hashCode();
    }

    public String toString() {
        return String.format("Subscription Group ID [%s] Topics %s Topic Pattern [%s]", this.groupId, this.topics, this.topicPattern);
    }

    private boolean isTopicSubscriptionMatched(Subscription subscription) {
        if (this.topics.size() == subscription.topics.size() && this.topics.containsAll(subscription.topics)) {
            String regexLeft = this.topicPattern == null ? null : this.topicPattern.pattern();
            String regexRight = subscription.topicPattern == null ? null : subscription.topicPattern.pattern();
            return Objects.equals(regexLeft, regexRight);
        }
        return false;
    }
}

