/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.service.producer.transaction;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.nifi.kafka.service.api.producer.PublishContext;
import org.apache.nifi.kafka.service.api.record.KafkaRecord;
import org.apache.nifi.kafka.service.producer.ProducerCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaProducerWrapper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Producer<byte[], byte[]> producer;

    public KafkaProducerWrapper(Producer<byte[], byte[]> producer) {
        this.producer = producer;
    }

    public void send(Iterator<KafkaRecord> kafkaRecords, PublishContext publishContext, ProducerCallback callback) {
        while (kafkaRecords.hasNext()) {
            KafkaRecord kafkaRecord = kafkaRecords.next();
            ProducerRecord<byte[], byte[]> producerRecord = this.toProducerRecord(kafkaRecord, publishContext);
            this.producer.send(producerRecord, (Callback)callback);
            callback.send(producerRecord.topic());
        }
    }

    public abstract void commit();

    public abstract void abort();

    private ProducerRecord<byte[], byte[]> toProducerRecord(KafkaRecord kafkaRecord, PublishContext publishContext) {
        String topic = Optional.ofNullable(kafkaRecord.getTopic()).orElse(publishContext.getTopic());
        Integer partition = Optional.ofNullable(kafkaRecord.getPartition()).orElse(publishContext.getPartition());
        Integer moddedPartition = partition == null ? null : Integer.valueOf(Math.abs(partition) % this.producer.partitionsFor(topic).size());
        return new ProducerRecord(topic, moddedPartition, kafkaRecord.getTimestamp(), (Object)kafkaRecord.getKey(), (Object)kafkaRecord.getValue(), this.toKafkaHeadersNative(kafkaRecord));
    }

    private List<Header> toKafkaHeadersNative(KafkaRecord kafkaRecord) {
        return kafkaRecord.getHeaders().stream().map(h -> new RecordHeader(h.key(), h.value())).collect(Collectors.toList());
    }
}

