/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jolt.util;

import com.bazaarvoice.jolt.CardinalityTransform;
import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.Defaultr;
import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.Modifier;
import com.bazaarvoice.jolt.Removr;
import com.bazaarvoice.jolt.Shiftr;
import com.bazaarvoice.jolt.Sortr;
import com.bazaarvoice.jolt.SpecDriven;
import com.bazaarvoice.jolt.chainr.spec.ChainrEntry;
import com.bazaarvoice.jolt.exception.SpecException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.nifi.jolt.util.JoltTransformStrategy;

public class TransformFactory {
    public static JoltTransform getTransform(ClassLoader classLoader, String transformType, Object specJson) throws Exception {
        return switch (JoltTransformStrategy.get(transformType)) {
            case JoltTransformStrategy.DEFAULTR -> new Defaultr(specJson);
            case JoltTransformStrategy.SHIFTR -> new Shiftr(specJson);
            case JoltTransformStrategy.REMOVR -> new Removr(specJson);
            case JoltTransformStrategy.CARDINALITY -> new CardinalityTransform(specJson);
            case JoltTransformStrategy.SORTR -> new Sortr();
            case JoltTransformStrategy.MODIFIER_DEFAULTR -> new Modifier.Defaultr(specJson);
            case JoltTransformStrategy.MODIFIER_OVERWRITER -> new Modifier.Overwritr(specJson);
            case JoltTransformStrategy.MODIFIER_DEFINER -> new Modifier.Definr(specJson);
            case JoltTransformStrategy.CHAINR -> new Chainr(TransformFactory.getChainrJoltTransformations(classLoader, specJson));
            default -> null;
        };
    }

    public static JoltTransform getCustomTransform(ClassLoader classLoader, String customTransformType, Object specJson) throws Exception {
        Class<?> clazz = classLoader.loadClass(customTransformType);
        if (SpecDriven.class.isAssignableFrom(clazz)) {
            Constructor<?> constructor = clazz.getConstructor(Object.class);
            return (JoltTransform)constructor.newInstance(specJson);
        }
        return (JoltTransform)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected static List<JoltTransform> getChainrJoltTransformations(ClassLoader classLoader, Object specJson) throws Exception {
        if (!(specJson instanceof List)) {
            throw new SpecException("JOLT Chainr expects a JSON array of objects - Malformed spec.");
        }
        List operations = (List)specJson;
        if (operations.isEmpty()) {
            throw new SpecException("JOLT Chainr passed an empty JSON array.");
        }
        ArrayList<JoltTransform> entries = new ArrayList<JoltTransform>(operations.size());
        for (Object chainrEntryObj : operations) {
            if (!(chainrEntryObj instanceof Map)) {
                throw new SpecException("JOLT ChainrEntry expects a JSON map - Malformed spec");
            }
            Map chainrEntryMap = (Map)chainrEntryObj;
            String opString = (String)chainrEntryMap.get("operation");
            if (opString == null) {
                throw new SpecException("JOLT Chainr 'operation' must implement Transform or ContextualTransform");
            }
            String operationClassName = ChainrEntry.STOCK_TRANSFORMS.getOrDefault(opString, opString);
            entries.add(TransformFactory.getCustomTransform(classLoader, operationClassName, chainrEntryMap.get("spec")));
        }
        return entries;
    }
}

