/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jolt.util;

import java.util.Arrays;
import org.apache.nifi.components.DescribedValue;

public enum JoltTransformStrategy implements DescribedValue
{
    SHIFTR("jolt-transform-shift", "Shift", "Shift input JSON/data to create the output JSON."),
    CHAINR("jolt-transform-chain", "Chain", "Execute list of Jolt transformations."),
    DEFAULTR("jolt-transform-default", "Default", "Apply default values to the output JSON."),
    REMOVR("jolt-transform-remove", "Remove", "Remove values from input data to create the output JSON."),
    CARDINALITY("jolt-transform-card", "Cardinality", "Change the cardinality of input elements to create the output JSON."),
    SORTR("jolt-transform-sort", "Sort", "Sort input json key values alphabetically. Any specification set is ignored."),
    CUSTOMR("jolt-transform-custom", "Custom", "Custom Transformation. Requires Custom Transformation Class Name"),
    MODIFIER_DEFAULTR("jolt-transform-modify-default", "Modify - Default", "Writes when key is missing or value is null"),
    MODIFIER_OVERWRITER("jolt-transform-modify-overwrite", "Modify - Overwrite", "Always overwrite value"),
    MODIFIER_DEFINER("jolt-transform-modify-define", "Modify - Define", "Writes when key is missing");

    private final String value;
    private final String displayName;
    private final String description;

    private JoltTransformStrategy(String value, String displayName, String description) {
        this.value = value;
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public static JoltTransformStrategy get(String value) {
        return Arrays.stream(JoltTransformStrategy.values()).filter(strategy -> strategy.getValue().equals(value)).findFirst().orElse(CHAINR);
    }
}

