/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class Utils {
    static <T> T newDefaultInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load and/or instantiate class '" + className + "'", e);
        }
    }

    public static Method findMethod(String name, Class<?> targetClass) {
        for (Class<?> searchType = targetClass; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName())) continue;
                return method;
            }
        }
        return null;
    }

    public static Method[] findMethods(String name, Class<?> targetClass) {
        ArrayList<Method> fittingMethods = new ArrayList<Method>();
        for (Class<?> searchType = targetClass; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName())) continue;
                fittingMethods.add(method);
            }
        }
        if (fittingMethods.isEmpty()) {
            return null;
        }
        Collections.sort(fittingMethods, Comparator.comparing(Method::getParameterCount));
        return fittingMethods.toArray(new Method[fittingMethods.size()]);
    }
}

