/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.log;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.nifi.web.security.log.AuthenticationUserAttribute;
import org.apache.nifi.web.server.log.UserPrincipal;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.internal.DefaultUserIdentity;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestAuthenticationFilter
extends OncePerRequestFilter {
    private static final Subject DEFAULT_SUBJECT = new Subject();
    private static final String[] DEFAULT_ROLES = new String[0];
    private static final String METHOD = "FILTER";
    private static final Logger logger = LoggerFactory.getLogger(RequestAuthenticationFilter.class);

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        Object usernameAttribute = httpServletRequest.getAttribute(AuthenticationUserAttribute.USERNAME.getName());
        if (usernameAttribute == null) {
            logger.debug("Username not found Remote Address [{}]", (Object)httpServletRequest.getRemoteAddr());
        } else {
            String username = usernameAttribute.toString();
            UserPrincipal principal = new UserPrincipal(username);
            DefaultUserIdentity userIdentity = new DefaultUserIdentity(DEFAULT_SUBJECT, (Principal)principal, DEFAULT_ROLES);
            LoginAuthenticator.UserAuthenticationSucceeded authenticationState = new LoginAuthenticator.UserAuthenticationSucceeded(METHOD, (UserIdentity)userIdentity);
            httpServletRequest.setAttribute(Request.AuthenticationState.class.getName(), (Object)authenticationState);
        }
    }
}

