/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.connector;

import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;

public class HostPortValidatorCustomizer
implements HttpConfiguration.Customizer {
    private static final String MISDIRECTED_REQUEST_REASON = "Invalid Port Requested";
    private static final int PORT_NOT_SPECIFIED = -1;
    private final Set<Integer> validPorts;

    public HostPortValidatorCustomizer(Set<Integer> validPorts) {
        this.validPorts = Objects.requireNonNull(validPorts, "Valid Ports required");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Request customize(Request request, HttpFields.Mutable responseHeaders) {
        if (!request.isSecure()) return request;
        HttpURI requestUri = request.getHttpURI();
        int port = requestUri.getPort();
        int localSocketAddressPort = this.getLocalSocketAddressPort(request);
        if (-1 == port) return request;
        if (localSocketAddressPort == port) return request;
        if (!this.validPorts.contains(port)) throw new BadMessageException(421, MISDIRECTED_REQUEST_REASON);
        return request;
    }

    private int getLocalSocketAddressPort(Request request) {
        ConnectionMetaData connectionMetaData = request.getConnectionMetaData();
        InetSocketAddress localSocketAddress = (InetSocketAddress)connectionMetaData.getLocalSocketAddress();
        return localSocketAddress.getPort();
    }
}

