/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.lifecycle.LifeCycleStartException;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.ContentAccess;
import org.apache.nifi.web.NiFiWebConfigurationContext;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.server.ServerConfigurationException;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class JettyServer
implements NiFiServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private static final String WEB_DEFAULTS_XML = "org/apache/nifi/web/webdefault.xml";
    private static final int HEADER_BUFFER_SIZE = 16384;
    private static final FileFilter WAR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String nameToTest = pathname.getName().toLowerCase();
            return nameToTest.endsWith(".war") && pathname.isFile();
        }
    };
    private final Server server;
    private final NiFiProperties props;
    private ExtensionMapping extensionMapping;
    private WebAppContext webApiContext;
    private WebAppContext webDocsContext;
    private WebAppContext webContentViewerContext;
    private Collection<WebAppContext> contentViewerWebContexts;
    private UiExtensionMapping componentUiExtensions;
    private Collection<WebAppContext> componentUiExtensionWebContexts;

    public JettyServer(NiFiProperties props) {
        QueuedThreadPool threadPool = new QueuedThreadPool(props.getWebThreads());
        threadPool.setName("NiFi Web Server");
        this.server = new Server((ThreadPool)threadPool);
        this.props = props;
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this.server);
        classlist.addBefore(JettyWebXmlConfiguration.class.getName(), new String[]{AnnotationConfiguration.class.getName()});
        this.configureConnectors(this.server);
        this.loadWars(this.locateNarWorkingDirectories());
    }

    private Set<File> locateNarWorkingDirectories() {
        File frameworkWorkingDir = this.props.getFrameworkWorkingDirectory();
        File extensionsWorkingDir = this.props.getExtensionsWorkingDirectory();
        File[] frameworkDir = frameworkWorkingDir.listFiles();
        if (frameworkDir == null) {
            throw new IllegalStateException(String.format("Unable to access framework working directory: %s", frameworkWorkingDir.getAbsolutePath()));
        }
        File[] extensionDirs = extensionsWorkingDir.listFiles();
        if (extensionDirs == null) {
            throw new IllegalStateException(String.format("Unable to access extensions working directory: %s", extensionsWorkingDir.getAbsolutePath()));
        }
        HashSet<File> narWorkingDirectories = new HashSet<File>(Arrays.asList(frameworkDir));
        narWorkingDirectories.addAll(Arrays.asList(extensionDirs));
        return narWorkingDirectories;
    }

    private void loadWars(Set<File> narWorkingDirectories) {
        Map<File, File> warToNarWorkingDirectoryLookup = this.findWars(narWorkingDirectories);
        File webUiWar = null;
        File webApiWar = null;
        File webErrorWar = null;
        File webDocsWar = null;
        File webContentViewerWar = null;
        ArrayList<File> otherWars = new ArrayList<File>();
        for (File war : warToNarWorkingDirectoryLookup.keySet()) {
            if (war.getName().toLowerCase().startsWith("nifi-web-api")) {
                webApiWar = war;
                continue;
            }
            if (war.getName().toLowerCase().startsWith("nifi-web-error")) {
                webErrorWar = war;
                continue;
            }
            if (war.getName().toLowerCase().startsWith("nifi-web-docs")) {
                webDocsWar = war;
                continue;
            }
            if (war.getName().toLowerCase().startsWith("nifi-web-content-viewer")) {
                webContentViewerWar = war;
                continue;
            }
            if (war.getName().toLowerCase().startsWith("nifi-web")) {
                webUiWar = war;
                continue;
            }
            otherWars.add(war);
        }
        if (webUiWar == null) {
            throw new RuntimeException("Unable to load nifi-web WAR");
        }
        if (webApiWar == null) {
            throw new RuntimeException("Unable to load nifi-web-api WAR");
        }
        if (webDocsWar == null) {
            throw new RuntimeException("Unable to load nifi-web-docs WAR");
        }
        if (webErrorWar == null) {
            throw new RuntimeException("Unable to load nifi-web-error WAR");
        }
        if (webContentViewerWar == null) {
            throw new RuntimeException("Unable to load nifi-web-content-viewer WAR");
        }
        HandlerCollection handlers = new HandlerCollection();
        HashMap<String, String> mimeMappings = new HashMap<String, String>();
        ClassLoader frameworkClassLoader = this.getClass().getClassLoader();
        ClassLoader jettyClassLoader = frameworkClassLoader.getParent();
        if (CollectionUtils.isNotEmpty(otherWars)) {
            this.componentUiExtensionWebContexts = new ArrayList<WebAppContext>();
            this.contentViewerWebContexts = new ArrayList<WebAppContext>();
            HashMap<String, ArrayList<UiExtension>> componentUiExtensionsByType = new HashMap<String, ArrayList<UiExtension>>();
            for (File war : otherWars) {
                HashMap<UiExtensionType, List<String>> uiExtensionInWar = new HashMap<UiExtensionType, List<String>>();
                this.identifyUiExtensionsForComponents(uiExtensionInWar, war);
                if (uiExtensionInWar.isEmpty()) continue;
                String warName = StringUtils.substringBeforeLast((String)war.getName(), (String)".");
                String warContextPath = String.format("/%s", warName);
                ClassLoader narClassLoaderForWar = NarClassLoaders.getInstance().getExtensionClassLoader(warToNarWorkingDirectoryLookup.get(war));
                if (narClassLoaderForWar == null) {
                    narClassLoaderForWar = jettyClassLoader;
                }
                WebAppContext extensionUiContext = this.loadWar(war, warContextPath, narClassLoaderForWar);
                for (Map.Entry entry : uiExtensionInWar.entrySet()) {
                    UiExtensionType extensionType = (UiExtensionType)entry.getKey();
                    List types = (List)entry.getValue();
                    if (UiExtensionType.ContentViewer.equals((Object)extensionType)) {
                        for (String contentType : types) {
                            mimeMappings.put(contentType, warContextPath);
                        }
                        this.contentViewerWebContexts.add(extensionUiContext);
                        continue;
                    }
                    for (String componentType : types) {
                        logger.info(String.format("Loading UI extension [%s, %s] for %s", extensionType, warContextPath, types));
                        UiExtension uiExtension = new UiExtension(extensionType, warContextPath);
                        ArrayList<UiExtension> componentUiExtensionsForType = (ArrayList<UiExtension>)componentUiExtensionsByType.get(componentType);
                        if (componentUiExtensionsForType == null) {
                            componentUiExtensionsForType = new ArrayList<UiExtension>();
                            componentUiExtensionsByType.put(componentType, componentUiExtensionsForType);
                        }
                        componentUiExtensionsForType.add(uiExtension);
                    }
                    this.componentUiExtensionWebContexts.add(extensionUiContext);
                }
                handlers.addHandler((Handler)extensionUiContext);
            }
            this.componentUiExtensions = new UiExtensionMapping(componentUiExtensionsByType);
        } else {
            this.componentUiExtensions = new UiExtensionMapping(Collections.EMPTY_MAP);
        }
        handlers.addHandler((Handler)this.loadWar(webUiWar, "/nifi", frameworkClassLoader));
        this.webApiContext = this.loadWar(webApiWar, "/nifi-api", frameworkClassLoader);
        handlers.addHandler((Handler)this.webApiContext);
        this.webContentViewerContext = this.loadWar(webContentViewerWar, "/nifi-content-viewer", frameworkClassLoader);
        this.webContentViewerContext.getInitParams().putAll(mimeMappings);
        handlers.addHandler((Handler)this.webContentViewerContext);
        String docsContextPath = "/nifi-docs";
        this.webDocsContext = this.loadWar(webDocsWar, "/nifi-docs", frameworkClassLoader);
        ContextHandlerCollection documentationHandlers = new ContextHandlerCollection();
        documentationHandlers.addHandler((Handler)this.createDocsWebApp("/nifi-docs"));
        documentationHandlers.addHandler((Handler)this.webDocsContext);
        handlers.addHandler((Handler)documentationHandlers);
        handlers.addHandler((Handler)this.loadWar(webErrorWar, "/", frameworkClassLoader));
        this.server.setHandler(this.gzip((Handler)handlers));
    }

    private Handler gzip(Handler handler) {
        GzipHandler gzip = new GzipHandler();
        gzip.setIncludedMethods(new String[]{"GET", "POST", "PUT", "DELETE"});
        gzip.setHandler(handler);
        return gzip;
    }

    private Map<File, File> findWars(Set<File> narWorkingDirectories) {
        HashMap<File, File> wars = new HashMap<File, File>();
        for (File narWorkingDirectory : narWorkingDirectories) {
            File narDependencies = new File(narWorkingDirectory, "META-INF/bundled-dependencies");
            if (!narDependencies.isDirectory()) continue;
            File[] narDependencyDirs = narDependencies.listFiles(WAR_FILTER);
            if (narDependencyDirs == null) {
                throw new IllegalStateException(String.format("Unable to access working directory for NAR dependencies in: %s", narDependencies.getAbsolutePath()));
            }
            for (File war : narDependencyDirs) {
                wars.put(war, narWorkingDirectory);
            }
        }
        return wars;
    }

    private void readUiExtensions(Map<UiExtensionType, List<String>> uiExtensions, UiExtensionType uiExtensionType, JarFile jarFile, JarEntry jarEntry) throws IOException {
        if (jarEntry == null) {
            return;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry)));){
            String rawComponentType;
            while ((rawComponentType = in.readLine()) != null) {
                String componentType = this.extractComponentType(rawComponentType);
                if (componentType == null) continue;
                List<String> extensions = uiExtensions.get(uiExtensionType);
                if (extensions == null) {
                    extensions = new ArrayList<String>();
                    uiExtensions.put(uiExtensionType, extensions);
                }
                extensions.add(componentType);
            }
        }
    }

    private void identifyUiExtensionsForComponents(Map<UiExtensionType, List<String>> uiExtensions, File warFile) {
        try (JarFile jarFile = new JarFile(warFile);){
            this.readUiExtensions(uiExtensions, UiExtensionType.ContentViewer, jarFile, jarFile.getJarEntry("META-INF/nifi-content-viewer"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ProcessorConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-processor-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ControllerServiceConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-controller-service-configuration"));
            this.readUiExtensions(uiExtensions, UiExtensionType.ReportingTaskConfiguration, jarFile, jarFile.getJarEntry("META-INF/nifi-reporting-task-configuration"));
        }
        catch (IOException ioe) {
            logger.warn(String.format("Unable to inspect %s for a UI extensions.", warFile));
        }
    }

    private String extractComponentType(String line) {
        String trimmedLine = line.trim();
        if (!trimmedLine.isEmpty() && !trimmedLine.startsWith("#")) {
            int indexOfPound = trimmedLine.indexOf("#");
            return indexOfPound > 0 ? trimmedLine.substring(0, indexOfPound) : trimmedLine;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getWarExtensions(File war, String path) {
        JarFile jarFile;
        ArrayList<String> processorTypes;
        block17: {
            processorTypes = new ArrayList<String>();
            jarFile = null;
            try {
                jarFile = new JarFile(war);
                JarEntry jarEntry = jarFile.getJarEntry(path);
                if (jarEntry == null) break block17;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry)));){
                    String rawProcessorType;
                    while ((rawProcessorType = in.readLine()) != null) {
                        String processorType = this.extractComponentType(rawProcessorType);
                        if (processorType == null) continue;
                        processorTypes.add(processorType);
                    }
                }
            }
            catch (IOException ioe) {
                try {
                    logger.warn("Unable to inspect {} for a custom processor UI.", new Object[]{war, ioe});
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(jarFile);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)jarFile);
            }
        }
        IOUtils.closeQuietly((Closeable)jarFile);
        return processorTypes;
    }

    private WebAppContext loadWar(File warFile, String contextPath, ClassLoader parentClassLoader) {
        boolean made;
        WebAppContext webappContext = new WebAppContext(warFile.getPath(), contextPath);
        webappContext.setContextPath(contextPath);
        webappContext.setDisplayName(contextPath);
        webappContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\\\.jar$|.*/[^/]*taglibs.*\\.jar$");
        ArrayList<String> serverClasses = new ArrayList<String>(Arrays.asList(webappContext.getServerClasses()));
        serverClasses.remove("org.slf4j.");
        webappContext.setServerClasses(serverClasses.toArray(new String[0]));
        webappContext.setDefaultsDescriptor(WEB_DEFAULTS_XML);
        File tempDir = new File(this.props.getWebWorkingDirectory(), warFile.getName());
        if (tempDir.exists() && !tempDir.isDirectory()) {
            throw new RuntimeException(tempDir.getAbsolutePath() + " is not a directory");
        }
        if (!tempDir.exists() && !(made = tempDir.mkdirs())) {
            throw new RuntimeException(tempDir.getAbsolutePath() + " could not be created");
        }
        if (!tempDir.canRead() || !tempDir.canWrite()) {
            throw new RuntimeException(tempDir.getAbsolutePath() + " directory does not have read/write privilege");
        }
        webappContext.setTempDirectory(tempDir);
        webappContext.setMaxFormContentSize(600000);
        try {
            webappContext.setClassLoader((ClassLoader)new WebAppClassLoader(parentClassLoader, (WebAppClassLoader.Context)webappContext));
        }
        catch (IOException ioe) {
            this.startUpFailure(ioe);
        }
        logger.info("Loading WAR: " + warFile.getAbsolutePath() + " with context path set to " + contextPath);
        return webappContext;
    }

    private ContextHandler createDocsWebApp(String contextPath) {
        try {
            boolean made;
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setDirectoriesListed(false);
            File docsDir = Paths.get("docs", new String[0]).toRealPath(new LinkOption[0]).toFile();
            Resource docsResource = Resource.newResource((File)docsDir);
            String componentDocsDirPath = this.props.getProperty("nifi.documentation.working.directory", "work/docs/components");
            File workingDocsDirectory = Paths.get(componentDocsDirPath, new String[0]).toRealPath(new LinkOption[0]).getParent().toFile();
            Resource workingDocsResource = Resource.newResource((File)workingDocsDirectory);
            File webApiDocsDir = new File(this.webApiContext.getTempDirectory(), "webapp/docs");
            if (!webApiDocsDir.exists() && !(made = webApiDocsDir.mkdirs())) {
                throw new RuntimeException(webApiDocsDir.getAbsolutePath() + " could not be created");
            }
            Resource webApiDocsResource = Resource.newResource((File)webApiDocsDir);
            ResourceCollection resources = new ResourceCollection(new Resource[]{docsResource, workingDocsResource, webApiDocsResource});
            resourceHandler.setBaseResource((Resource)resources);
            ContextHandler handler = new ContextHandler(contextPath);
            handler.setHandler((Handler)resourceHandler);
            logger.info("Loading documents web app with context path set to " + contextPath);
            return handler;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Resource directory paths are malformed: " + ex.getMessage());
        }
    }

    private void configureConnectors(Server server) throws ServerConfigurationException {
        Integer port;
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setRequestHeaderSize(16384);
        httpConfiguration.setResponseHeaderSize(16384);
        if (this.props.getPort() != null) {
            port = this.props.getPort();
            if (port < 0 || (int)Math.pow(2.0, 16.0) <= port) {
                throw new ServerConfigurationException("Invalid HTTP port: " + port);
            }
            logger.info("Configuring Jetty for HTTP on port: " + port);
            ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
            if (StringUtils.isNotBlank((CharSequence)this.props.getProperty("nifi.web.http.host"))) {
                http.setHost(this.props.getProperty("nifi.web.http.host"));
            }
            http.setPort(port.intValue());
            server.addConnector((Connector)http);
        }
        if (this.props.getSslPort() != null) {
            port = this.props.getSslPort();
            if (port < 0 || (int)Math.pow(2.0, 16.0) <= port) {
                throw new ServerConfigurationException("Invalid HTTPs port: " + port);
            }
            logger.info("Configuring Jetty for HTTPs on port: " + port);
            HttpConfiguration httpsConfiguration = new HttpConfiguration(httpConfiguration);
            httpsConfiguration.setSecureScheme("https");
            httpsConfiguration.setSecurePort(this.props.getSslPort().intValue());
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(this.createSslContextFactory(), "http/1.1"), new HttpConnectionFactory(httpsConfiguration)});
            if (StringUtils.isNotBlank((CharSequence)this.props.getProperty("nifi.web.https.host"))) {
                https.setHost(this.props.getProperty("nifi.web.https.host"));
            }
            https.setPort(port.intValue());
            server.addConnector((Connector)https);
        }
    }

    private SslContextFactory createSslContextFactory() {
        SslContextFactory contextFactory = new SslContextFactory();
        JettyServer.configureSslContextFactory(contextFactory, this.props);
        return contextFactory;
    }

    protected static void configureSslContextFactory(SslContextFactory contextFactory, NiFiProperties props) {
        String trustStoreType;
        String keyStoreType;
        if (props.isClientAuthRequiredForRestApi()) {
            contextFactory.setNeedClientAuth(true);
        } else {
            contextFactory.setWantClientAuth(true);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getProperty("nifi.security.keystore"))) {
            contextFactory.setKeyStorePath(props.getProperty("nifi.security.keystore"));
        }
        if (StringUtils.isNotBlank((CharSequence)(keyStoreType = props.getProperty("nifi.security.keystoreType")))) {
            contextFactory.setKeyStoreType(keyStoreType);
            String keyStoreProvider = KeyStoreUtils.getKeyStoreProvider((String)keyStoreType);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{keyStoreProvider})) {
                contextFactory.setKeyStoreProvider(keyStoreProvider);
            }
        }
        String keystorePassword = props.getProperty("nifi.security.keystorePasswd");
        String keyPassword = props.getProperty("nifi.security.keyPasswd");
        if (StringUtils.isNotBlank((CharSequence)keystorePassword)) {
            String defaultKeyPassword = StringUtils.isBlank((CharSequence)keyPassword) ? keystorePassword : keyPassword;
            contextFactory.setKeyStorePassword(keystorePassword);
            contextFactory.setKeyManagerPassword(defaultKeyPassword);
        } else if (StringUtils.isNotBlank((CharSequence)keyPassword)) {
            contextFactory.setKeyManagerPassword(keyPassword);
        }
        if (StringUtils.isNotBlank((CharSequence)props.getProperty("nifi.security.truststore"))) {
            contextFactory.setTrustStorePath(props.getProperty("nifi.security.truststore"));
        }
        if (StringUtils.isNotBlank((CharSequence)(trustStoreType = props.getProperty("nifi.security.truststoreType")))) {
            contextFactory.setTrustStoreType(trustStoreType);
            String trustStoreProvider = KeyStoreUtils.getKeyStoreProvider((String)trustStoreType);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{trustStoreProvider})) {
                contextFactory.setTrustStoreProvider(trustStoreProvider);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)props.getProperty("nifi.security.truststorePasswd"))) {
            contextFactory.setTrustStorePassword(props.getProperty("nifi.security.truststorePasswd"));
        }
    }

    public void start() {
        try {
            this.server.start();
            for (Handler handler : this.server.getChildHandlers()) {
                WebAppContext context;
                if (!(handler instanceof WebAppContext) || (context = (WebAppContext)handler).getUnavailableException() == null) continue;
                this.startUpFailure(context.getUnavailableException());
            }
            if (this.webApiContext != null) {
                FilterHolder securityFilter;
                ServletContext webApiServletContext = this.webApiContext.getServletHandler().getServletContext();
                webApiServletContext.setAttribute("nifi-ui-extensions", (Object)this.componentUiExtensions);
                WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)webApiServletContext);
                if (CollectionUtils.isNotEmpty(this.componentUiExtensionWebContexts)) {
                    NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)webApplicationContext.getBean("nifiWebConfigurationContext", NiFiWebConfigurationContext.class);
                    for (WebAppContext customUiContext : this.componentUiExtensionWebContexts) {
                        ServletContext customUiServletContext = customUiContext.getServletHandler().getServletContext();
                        customUiServletContext.setAttribute("nifi-web-configuration-context", (Object)configurationContext);
                        FilterHolder securityFilter2 = this.webApiContext.getServletHandler().getFilter("springSecurityFilterChain");
                        if (securityFilter2 == null) continue;
                        customUiContext.addFilter(securityFilter2, "/*", EnumSet.allOf(DispatcherType.class));
                    }
                }
                if (CollectionUtils.isNotEmpty(this.contentViewerWebContexts)) {
                    for (WebAppContext contentViewerContext : this.contentViewerWebContexts) {
                        securityFilter = this.webApiContext.getServletHandler().getFilter("springSecurityFilterChain");
                        if (securityFilter == null) continue;
                        contentViewerContext.addFilter(securityFilter, "/*", EnumSet.allOf(DispatcherType.class));
                    }
                }
                if (this.webContentViewerContext != null) {
                    ContentAccess contentAccess = (ContentAccess)webApplicationContext.getBean("contentAccess", ContentAccess.class);
                    ServletContext webContentViewerServletContext = this.webContentViewerContext.getServletHandler().getServletContext();
                    webContentViewerServletContext.setAttribute("nifi-content-access", (Object)contentAccess);
                    securityFilter = this.webApiContext.getServletHandler().getFilter("springSecurityFilterChain");
                    if (securityFilter != null) {
                        this.webContentViewerContext.addFilter(securityFilter, "/*", EnumSet.allOf(DispatcherType.class));
                    }
                }
            }
            if (this.webDocsContext != null) {
                ServletContext webDocsServletContext = this.webDocsContext.getServletHandler().getServletContext();
                webDocsServletContext.setAttribute("nifi-extension-mapping", (Object)this.extensionMapping);
            }
            if (this.props.isNode()) {
                FlowService flowService = null;
                try {
                    logger.info("Loading Flow...");
                    WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.webApiContext.getServletContext());
                    flowService = (FlowService)ctx.getBean("flowService", FlowService.class);
                    flowService.start();
                    flowService.load(null);
                    logger.info("Flow loaded successfully.");
                }
                catch (IOException | UninheritableFlowException | FlowSerializationException | FlowSynchronizationException | LifeCycleStartException | BeansException e) {
                    if (flowService != null && flowService.isRunning()) {
                        flowService.stop(false);
                    }
                    throw new Exception("Unable to load flow due to: " + e, e);
                }
            }
            this.dumpUrls();
        }
        catch (Exception ex) {
            this.startUpFailure(ex);
        }
    }

    private void dumpUrls() throws SocketException {
        ArrayList<String> urls = new ArrayList<String>();
        for (Connector connector : this.server.getConnectors()) {
            if (!(connector instanceof ServerConnector)) continue;
            ServerConnector serverConnector = (ServerConnector)connector;
            HashSet<String> hosts = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)serverConnector.getHost())) {
                hosts.add(serverConnector.getHost());
            } else {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                if (networkInterfaces != null) {
                    for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
                        for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                            hosts.add(inetAddress.getHostAddress());
                        }
                    }
                }
            }
            if (hosts.isEmpty()) continue;
            String scheme = "http";
            if (this.props.getSslPort() != null && serverConnector.getPort() == this.props.getSslPort().intValue()) {
                scheme = "https";
            }
            for (String host : hosts) {
                urls.add(String.format("%s://%s:%s", scheme, host, serverConnector.getPort()));
            }
        }
        if (urls.isEmpty()) {
            logger.warn("NiFi has started, but the UI is not available on any hosts. Please verify the host properties.");
        } else {
            logger.info("NiFi has started. The UI is available at the following URLs:");
            for (String url : urls) {
                logger.info(String.format("%s/nifi", url));
            }
        }
    }

    private void startUpFailure(Throwable t) {
        System.err.println("Failed to start web server: " + t.getMessage());
        System.err.println("Shutting down...");
        logger.warn("Failed to start web server... shutting down.", t);
        System.exit(1);
    }

    public void setExtensionMapping(ExtensionMapping extensionMapping) {
        this.extensionMapping = extensionMapping;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            logger.warn("Failed to stop web server", (Throwable)ex);
        }
    }
}

