/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.writer;

import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.UnpartitionedWriter;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.nifi.processors.iceberg.writer.IcebergPartitionedWriter;

public class IcebergTaskWriterFactory {
    private final Schema schema;
    private final PartitionSpec spec;
    private final FileIO io;
    private final long targetFileSize;
    private final FileFormat fileFormat;
    private final FileAppenderFactory<Record> appenderFactory;
    private final OutputFileFactory outputFileFactory;

    public IcebergTaskWriterFactory(Table table, long taskId, FileFormat fileFormat, String targetFileSize) {
        this.schema = table.schema();
        this.spec = table.spec();
        this.io = table.io();
        this.fileFormat = fileFormat;
        this.targetFileSize = targetFileSize != null ? Long.parseLong(targetFileSize) : PropertyUtil.propertyAsLong((Map)table.properties(), (String)"write.target-file-size-bytes", (long)0x20000000L);
        this.outputFileFactory = OutputFileFactory.builderFor((Table)table, (int)table.spec().specId(), (long)taskId).format(fileFormat).build();
        this.appenderFactory = new GenericAppenderFactory(this.schema, this.spec);
    }

    public TaskWriter<Record> create() {
        if (this.spec.isUnpartitioned()) {
            return new UnpartitionedWriter(this.spec, this.fileFormat, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSize);
        }
        return new IcebergPartitionedWriter(this.spec, this.fileFormat, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSize, this.schema);
    }
}

