/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.catalog;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.nifi.processors.iceberg.IcebergUtils;
import org.apache.nifi.services.iceberg.IcebergCatalogProperty;
import org.apache.nifi.services.iceberg.IcebergCatalogService;

public class IcebergCatalogFactory {
    private final IcebergCatalogService catalogService;

    public IcebergCatalogFactory(IcebergCatalogService catalogService) {
        this.catalogService = catalogService;
    }

    public Catalog create() {
        switch (this.catalogService.getCatalogType()) {
            case HIVE: {
                return this.initHiveCatalog(this.catalogService);
            }
            case HADOOP: {
                return this.initHadoopCatalog(this.catalogService);
            }
        }
        throw new IllegalArgumentException("Unknown catalog type: " + this.catalogService.getCatalogType());
    }

    private Catalog initHiveCatalog(IcebergCatalogService catalogService) {
        HiveCatalog catalog = new HiveCatalog();
        if (catalogService.getConfigFilePaths() != null) {
            Configuration configuration = IcebergUtils.getConfigurationFromFiles(catalogService.getConfigFilePaths());
            catalog.setConf(configuration);
        }
        Map catalogProperties = catalogService.getCatalogProperties();
        HashMap properties = new HashMap();
        if (catalogProperties.containsKey(IcebergCatalogProperty.METASTORE_URI)) {
            properties.put("uri", catalogProperties.get(IcebergCatalogProperty.METASTORE_URI));
        }
        if (catalogProperties.containsKey(IcebergCatalogProperty.WAREHOUSE_LOCATION)) {
            properties.put("warehouse", catalogProperties.get(IcebergCatalogProperty.WAREHOUSE_LOCATION));
        }
        catalog.initialize("hive-catalog", properties);
        return catalog;
    }

    private Catalog initHadoopCatalog(IcebergCatalogService catalogService) {
        Map catalogProperties = catalogService.getCatalogProperties();
        String warehousePath = (String)catalogProperties.get(IcebergCatalogProperty.WAREHOUSE_LOCATION);
        if (catalogService.getConfigFilePaths() != null) {
            return new HadoopCatalog(IcebergUtils.getConfigurationFromFiles(catalogService.getConfigFilePaths()), warehousePath);
        }
        return new HadoopCatalog(new Configuration(), warehousePath);
    }
}

