/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.converter;

import java.io.Serializable;
import java.time.ZoneId;
import javax.annotation.Nullable;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.serialization.record.util.IllegalTypeConversionException;

public class ArrayElementGetter {
    private static final String ARRAY_FIELD_NAME = "array element";

    public static ElementGetter createElementGetter(DataType dataType) {
        ElementGetter elementGetter;
        switch (dataType.getFieldType()) {
            case STRING: {
                elementGetter = element -> DataTypeUtils.toString((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case CHAR: {
                elementGetter = element -> DataTypeUtils.toCharacter((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case BOOLEAN: {
                elementGetter = element -> DataTypeUtils.toBoolean((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case DECIMAL: {
                elementGetter = element -> DataTypeUtils.toBigDecimal((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case BYTE: {
                elementGetter = element -> DataTypeUtils.toByte((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case SHORT: {
                elementGetter = element -> DataTypeUtils.toShort((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case INT: {
                elementGetter = element -> DataTypeUtils.toInteger((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case DATE: {
                elementGetter = element -> DataTypeUtils.toLocalDate((Object)element, () -> DataTypeUtils.getDateTimeFormatter((String)dataType.getFormat(), (ZoneId)ZoneId.systemDefault()), (String)ARRAY_FIELD_NAME);
                break;
            }
            case TIME: {
                elementGetter = element -> DataTypeUtils.toTime((Object)element, () -> DataTypeUtils.getDateFormat((String)dataType.getFormat()), (String)ARRAY_FIELD_NAME);
                break;
            }
            case LONG: {
                elementGetter = element -> DataTypeUtils.toLong((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case BIGINT: {
                elementGetter = element -> DataTypeUtils.toBigInt((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case FLOAT: {
                elementGetter = element -> DataTypeUtils.toFloat((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case DOUBLE: {
                elementGetter = element -> DataTypeUtils.toDouble((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case TIMESTAMP: {
                elementGetter = element -> DataTypeUtils.toTimestamp((Object)element, () -> DataTypeUtils.getDateFormat((String)dataType.getFormat()), (String)ARRAY_FIELD_NAME);
                break;
            }
            case UUID: {
                elementGetter = DataTypeUtils::toUUID;
                break;
            }
            case ARRAY: {
                elementGetter = element -> DataTypeUtils.toArray((Object)element, (String)ARRAY_FIELD_NAME, (DataType)((ArrayDataType)dataType).getElementType());
                break;
            }
            case MAP: {
                elementGetter = element -> DataTypeUtils.toMap((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case RECORD: {
                elementGetter = element -> DataTypeUtils.toRecord((Object)element, (String)ARRAY_FIELD_NAME);
                break;
            }
            case CHOICE: {
                elementGetter = element -> {
                    ChoiceDataType choiceDataType = (ChoiceDataType)dataType;
                    DataType chosenDataType = DataTypeUtils.chooseDataType((Object)element, (ChoiceDataType)choiceDataType);
                    if (chosenDataType == null) {
                        throw new IllegalTypeConversionException(String.format("Cannot convert value [%s] of type %s for array element to any of the following available Sub-Types for a Choice: %s", element, element.getClass(), choiceDataType.getPossibleSubTypes()));
                    }
                    return DataTypeUtils.convertType((Object)element, (DataType)chosenDataType, (String)ARRAY_FIELD_NAME);
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported field type: " + dataType.getFieldType());
            }
        }
        return element -> {
            if (element == null) {
                return null;
            }
            return elementGetter.getElementOrNull(element);
        };
    }

    public static interface ElementGetter
    extends Serializable {
        @Nullable
        public Object getElementOrNull(Object var1);
    }
}

