/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.converter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.schema.SchemaWithPartnerVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.nifi.processors.iceberg.converter.DataConverter;
import org.apache.nifi.processors.iceberg.converter.GenericDataConverters;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;

public class IcebergRecordConverter {
    private final DataConverter<Record, GenericRecord> converter;

    public GenericRecord convert(Record record) {
        return this.converter.convert(record);
    }

    public IcebergRecordConverter(Schema schema, RecordSchema recordSchema, FileFormat fileFormat) {
        this.converter = IcebergSchemaVisitor.visit(schema, new RecordDataType(recordSchema), fileFormat);
    }

    private static class RecordTypeWithFieldNameMapper
    extends RecordDataType {
        private final Map<String, String> fieldNameMap;

        RecordTypeWithFieldNameMapper(Schema schema, RecordDataType recordType) {
            super(recordType.getChildSchema());
            Map<String, String> lowerCaseMap = recordType.getChildSchema().getFieldNames().stream().collect(Collectors.toMap(String::toLowerCase, s -> s));
            this.fieldNameMap = new HashMap<String, String>();
            schema.columns().forEach(s -> this.fieldNameMap.put(s.name(), (String)lowerCaseMap.get(s.name().toLowerCase())));
        }

        Optional<String> getNameMapping(String name) {
            return Optional.ofNullable(this.fieldNameMap.get(name));
        }
    }

    private static class UUIDDataType
    extends DataType {
        private final FileFormat fileFormat;

        UUIDDataType(DataType dataType, FileFormat fileFormat) {
            super(dataType.getFieldType(), dataType.getFormat());
            this.fileFormat = fileFormat;
        }

        public FileFormat getFileFormat() {
            return this.fileFormat;
        }
    }

    public static class IcebergPartnerAccessors
    implements SchemaWithPartnerVisitor.PartnerAccessors<DataType> {
        private final Schema schema;
        private final FileFormat fileFormat;

        IcebergPartnerAccessors(Schema schema, FileFormat fileFormat) {
            this.schema = schema;
            this.fileFormat = fileFormat;
        }

        public DataType fieldPartner(DataType dataType, int fieldId, String name) {
            Validate.isTrue((boolean)(dataType instanceof RecordTypeWithFieldNameMapper), (String)String.format("Invalid record: %s is not a record", dataType));
            RecordTypeWithFieldNameMapper recordType = (RecordTypeWithFieldNameMapper)dataType;
            Optional<String> mappedFieldName = recordType.getNameMapping(name);
            Validate.isTrue((boolean)mappedFieldName.isPresent(), (String)String.format("Cannot find field with name '%s' in the record schema", name));
            Optional recordField = recordType.getChildSchema().getField(mappedFieldName.get());
            RecordField field = (RecordField)recordField.get();
            if (field.getDataType() instanceof RecordDataType) {
                return new RecordTypeWithFieldNameMapper(new Schema(this.schema.findField(fieldId).type().asStructType().fields()), (RecordDataType)field.getDataType());
            }
            if (field.getDataType().getFieldType().equals((Object)RecordFieldType.UUID) || this.schema.findField(fieldId).type().typeId() == Type.TypeID.UUID) {
                return new UUIDDataType(field.getDataType(), this.fileFormat);
            }
            return field.getDataType();
        }

        public DataType mapKeyPartner(DataType dataType) {
            return RecordFieldType.STRING.getDataType();
        }

        public DataType mapValuePartner(DataType dataType) {
            Validate.isTrue((boolean)(dataType instanceof MapDataType), (String)String.format("Invalid map: %s is not a map", dataType));
            MapDataType mapType = (MapDataType)dataType;
            return mapType.getValueType();
        }

        public DataType listElementPartner(DataType dataType) {
            Validate.isTrue((boolean)(dataType instanceof ArrayDataType), (String)String.format("Invalid array: %s is not an array", dataType));
            ArrayDataType arrayType = (ArrayDataType)dataType;
            return arrayType.getElementType();
        }
    }

    private static class IcebergSchemaVisitor
    extends SchemaWithPartnerVisitor<DataType, DataConverter<?, ?>> {
        private IcebergSchemaVisitor() {
        }

        public static DataConverter<?, ?> visit(Schema schema, RecordDataType recordDataType, FileFormat fileFormat) {
            return (DataConverter)IcebergSchemaVisitor.visit((Schema)schema, (Object)((Object)new RecordTypeWithFieldNameMapper(schema, recordDataType)), (SchemaWithPartnerVisitor)new IcebergSchemaVisitor(), (SchemaWithPartnerVisitor.PartnerAccessors)new IcebergPartnerAccessors(schema, fileFormat));
        }

        public DataConverter<?, ?> schema(Schema schema, DataType dataType, DataConverter<?, ?> converter) {
            return converter;
        }

        public DataConverter<?, ?> field(Types.NestedField field, DataType dataType, DataConverter<?, ?> converter) {
            converter.setTargetFieldName(field.name());
            return converter;
        }

        public DataConverter<?, ?> primitive(Type.PrimitiveType type, DataType dataType) {
            if (type.typeId() != null) {
                switch (type.typeId()) {
                    case BOOLEAN: 
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DATE: 
                    case STRING: {
                        return new GenericDataConverters.PrimitiveTypeConverter(type, dataType);
                    }
                    case TIME: {
                        return new GenericDataConverters.TimeConverter(dataType.getFormat());
                    }
                    case TIMESTAMP: {
                        Types.TimestampType timestampType = (Types.TimestampType)type;
                        if (timestampType.shouldAdjustToUTC()) {
                            return new GenericDataConverters.TimestampWithTimezoneConverter(dataType);
                        }
                        return new GenericDataConverters.TimestampConverter(dataType);
                    }
                    case UUID: {
                        UUIDDataType uuidType = (UUIDDataType)dataType;
                        if (uuidType.getFileFormat() == FileFormat.PARQUET) {
                            return new GenericDataConverters.UUIDtoByteArrayConverter();
                        }
                        return new GenericDataConverters.PrimitiveTypeConverter(type, dataType);
                    }
                    case FIXED: {
                        Types.FixedType fixedType = (Types.FixedType)type;
                        return new GenericDataConverters.FixedConverter(fixedType.length());
                    }
                    case BINARY: {
                        return new GenericDataConverters.BinaryConverter();
                    }
                    case DECIMAL: {
                        Types.DecimalType decimalType = (Types.DecimalType)type;
                        return new GenericDataConverters.BigDecimalConverter(decimalType.precision(), decimalType.scale());
                    }
                }
                throw new UnsupportedOperationException("Unsupported type: " + type.typeId());
            }
            throw new UnsupportedOperationException("Missing type id from PrimitiveType " + type);
        }

        public DataConverter<?, ?> struct(Types.StructType type, DataType dataType, List<DataConverter<?, ?>> converters) {
            Validate.notNull((Object)type, (String)"Can not create reader for null type");
            RecordTypeWithFieldNameMapper recordType = (RecordTypeWithFieldNameMapper)dataType;
            RecordSchema recordSchema = recordType.getChildSchema();
            for (DataConverter<?, ?> converter : converters) {
                Optional<String> mappedFieldName = recordType.getNameMapping(converter.getTargetFieldName());
                Optional recordField = recordSchema.getField(mappedFieldName.get());
                converter.setSourceFieldName(((RecordField)recordField.get()).getFieldName());
            }
            return new GenericDataConverters.RecordConverter(converters, recordSchema, type);
        }

        public DataConverter<?, ?> list(Types.ListType listTypeInfo, DataType dataType, DataConverter<?, ?> converter) {
            return new GenericDataConverters.ArrayConverter(converter, ((ArrayDataType)dataType).getElementType());
        }

        public DataConverter<?, ?> map(Types.MapType mapType, DataType dataType, DataConverter<?, ?> keyConverter, DataConverter<?, ?> valueConverter) {
            return new GenericDataConverters.MapConverter(keyConverter, RecordFieldType.STRING.getDataType(), valueConverter, ((MapDataType)dataType).getValueType());
        }
    }
}

