/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.converter;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.nifi.processors.iceberg.converter.ArrayElementGetter;
import org.apache.nifi.processors.iceberg.converter.DataConverter;
import org.apache.nifi.processors.iceberg.converter.RecordFieldGetter;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class GenericDataConverters {

    static class RecordConverter
    extends DataConverter<Record, GenericRecord> {
        private final List<DataConverter<?, ?>> converters;
        private final Map<String, RecordFieldGetter.FieldGetter> getters;
        private final Types.StructType schema;

        RecordConverter(List<DataConverter<?, ?>> converters, RecordSchema recordSchema, Types.StructType schema) {
            this.schema = schema;
            this.converters = converters;
            this.getters = new HashMap<String, RecordFieldGetter.FieldGetter>(converters.size());
            for (DataConverter<?, ?> converter : converters) {
                Optional recordField = recordSchema.getField(converter.getSourceFieldName());
                RecordField field = (RecordField)recordField.get();
                this.getters.put(converter.getTargetFieldName(), RecordFieldGetter.createFieldGetter(field.getDataType(), field.getFieldName(), field.isNullable()));
            }
        }

        @Override
        public GenericRecord convert(Record data) {
            GenericRecord record = GenericRecord.create((Types.StructType)this.schema);
            for (DataConverter<?, ?> converter : this.converters) {
                record.setField(converter.getTargetFieldName(), this.convert(data, converter));
            }
            return record;
        }

        private <S, T> T convert(Record record, DataConverter<S, T> converter) {
            return converter.convert(this.getters.get(converter.getTargetFieldName()).getFieldOrNull(record));
        }
    }

    static class MapConverter<SK, SV, TK, TV>
    extends DataConverter<Map<SK, SV>, Map<TK, TV>> {
        private final DataConverter<SK, TK> keyConverter;
        private final DataConverter<SV, TV> valueConverter;
        private final ArrayElementGetter.ElementGetter keyGetter;
        private final ArrayElementGetter.ElementGetter valueGetter;

        MapConverter(DataConverter<SK, TK> keyConverter, DataType keyType, DataConverter<SV, TV> valueConverter, DataType valueType) {
            this.keyConverter = keyConverter;
            this.keyGetter = ArrayElementGetter.createElementGetter(keyType);
            this.valueConverter = valueConverter;
            this.valueGetter = ArrayElementGetter.createElementGetter(valueType);
        }

        @Override
        public Map<TK, TV> convert(Map<SK, SV> data) {
            int mapSize = data.size();
            Object[] keyArray = data.keySet().toArray();
            Object[] valueArray = data.values().toArray();
            HashMap<TK, TV> result = new HashMap<TK, TV>(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                result.put(this.keyConverter.convert(this.keyGetter.getElementOrNull(keyArray[i])), this.valueConverter.convert(this.valueGetter.getElementOrNull(valueArray[i])));
            }
            return result;
        }
    }

    static class ArrayConverter<S, T>
    extends DataConverter<S[], List<T>> {
        private final DataConverter<S, T> fieldConverter;
        private final ArrayElementGetter.ElementGetter elementGetter;

        ArrayConverter(DataConverter<S, T> elementConverter, DataType dataType) {
            this.fieldConverter = elementConverter;
            this.elementGetter = ArrayElementGetter.createElementGetter(dataType);
        }

        @Override
        public List<T> convert(S[] data) {
            int numElements = data.length;
            ArrayList<T> result = new ArrayList<T>(numElements);
            for (int i = 0; i < numElements; ++i) {
                result.add(i, this.fieldConverter.convert(this.elementGetter.getElementOrNull(data[i])));
            }
            return result;
        }
    }

    static class BigDecimalConverter
    extends DataConverter<Object, BigDecimal> {
        private final int precision;
        private final int scale;

        BigDecimalConverter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public BigDecimal convert(Object data) {
            if (data instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)data;
                Validate.isTrue((bigDecimal.scale() == this.scale ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), wrong scale %s for value: %s", (Object[])new Object[]{this.precision, this.scale, bigDecimal.scale(), data});
                Validate.isTrue((bigDecimal.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), invalid precision %s for value: %s", (Object[])new Object[]{this.precision, this.scale, bigDecimal.precision(), data});
                return bigDecimal;
            }
            return DataTypeUtils.toBigDecimal((Object)data, null);
        }
    }

    static class BinaryConverter
    extends DataConverter<Byte[], ByteBuffer> {
        BinaryConverter() {
        }

        @Override
        public ByteBuffer convert(Byte[] data) {
            return ByteBuffer.wrap(ArrayUtils.toPrimitive((Byte[])data));
        }
    }

    static class FixedConverter
    extends DataConverter<Byte[], byte[]> {
        private final int length;

        FixedConverter(int length) {
            this.length = length;
        }

        @Override
        public byte[] convert(Byte[] data) {
            Validate.isTrue((data.length == this.length ? 1 : 0) != 0, (String)String.format("Cannot write byte array of length %s as fixed[%s]", data.length, this.length), (Object[])new Object[0]);
            return ArrayUtils.toPrimitive((Byte[])data);
        }
    }

    static class UUIDtoByteArrayConverter
    extends DataConverter<Object, byte[]> {
        UUIDtoByteArrayConverter() {
        }

        @Override
        public byte[] convert(Object data) {
            UUID uuid = DataTypeUtils.toUUID((Object)data);
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
            byteBuffer.putLong(uuid.getMostSignificantBits());
            byteBuffer.putLong(uuid.getLeastSignificantBits());
            return byteBuffer.array();
        }
    }

    static class TimestampWithTimezoneConverter
    extends DataConverter<Object, OffsetDateTime> {
        private final DataType dataType;

        public TimestampWithTimezoneConverter(DataType dataType) {
            this.dataType = dataType;
        }

        @Override
        public OffsetDateTime convert(Object data) {
            Timestamp convertedTimestamp = DataTypeUtils.toTimestamp((Object)data, () -> DataTypeUtils.getDateFormat((String)this.dataType.getFormat()), null);
            return OffsetDateTime.ofInstant(convertedTimestamp.toInstant(), ZoneId.of("UTC"));
        }
    }

    static class TimestampConverter
    extends DataConverter<Object, LocalDateTime> {
        private final DataType dataType;

        public TimestampConverter(DataType dataType) {
            this.dataType = dataType;
        }

        @Override
        public LocalDateTime convert(Object data) {
            Timestamp convertedTimestamp = DataTypeUtils.toTimestamp((Object)data, () -> DataTypeUtils.getDateFormat((String)this.dataType.getFormat()), null);
            return convertedTimestamp.toLocalDateTime();
        }
    }

    static class TimeConverter
    extends DataConverter<Object, LocalTime> {
        private final String timeFormat;

        public TimeConverter(String format) {
            this.timeFormat = format;
        }

        @Override
        public LocalTime convert(Object data) {
            return DataTypeUtils.toTime((Object)data, () -> DataTypeUtils.getDateFormat((String)this.timeFormat), null).toLocalTime();
        }
    }

    static class PrimitiveTypeConverter
    extends DataConverter<Object, Object> {
        final Type.PrimitiveType targetType;
        final DataType sourceType;

        public PrimitiveTypeConverter(Type.PrimitiveType type, DataType dataType) {
            this.targetType = type;
            this.sourceType = dataType;
        }

        @Override
        public Object convert(Object data) {
            switch (this.targetType.typeId()) {
                case BOOLEAN: {
                    return DataTypeUtils.toBoolean((Object)data, null);
                }
                case INTEGER: {
                    return DataTypeUtils.toInteger((Object)data, null);
                }
                case LONG: {
                    return DataTypeUtils.toLong((Object)data, null);
                }
                case FLOAT: {
                    return DataTypeUtils.toFloat((Object)data, null);
                }
                case DOUBLE: {
                    return DataTypeUtils.toDouble((Object)data, null);
                }
                case DATE: {
                    return DataTypeUtils.toLocalDate((Object)data, () -> DataTypeUtils.getDateTimeFormatter((String)this.sourceType.getFormat(), (ZoneId)ZoneId.systemDefault()), null);
                }
                case UUID: {
                    return DataTypeUtils.toUUID((Object)data);
                }
            }
            return DataTypeUtils.toString((Object)data, () -> null);
        }
    }
}

