/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.writer;

import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitionedFanoutWriter;

public class IcebergPartitionedWriter
extends PartitionedFanoutWriter<Record> {
    private final PartitionKey partitionKey;
    private final InternalRecordWrapper wrapper;

    IcebergPartitionedWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<Record> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
        this.partitionKey = new PartitionKey(spec, schema);
        this.wrapper = new InternalRecordWrapper(schema.asStruct());
    }

    protected PartitionKey partition(Record record) {
        this.partitionKey.partition((StructLike)this.wrapper.wrap((StructLike)record));
        return this.partitionKey;
    }
}

