/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.converter;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.schema.SchemaWithPartnerVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.nifi.processors.iceberg.converter.DataConverter;
import org.apache.nifi.processors.iceberg.converter.GenericDataConverters;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;

public class IcebergRecordConverter {
    private final DataConverter<Record, GenericRecord> converter;

    public GenericRecord convert(Record record) {
        return this.converter.convert(record);
    }

    public IcebergRecordConverter(Schema schema, RecordSchema recordSchema, FileFormat fileFormat) {
        this.converter = IcebergSchemaVisitor.visit(schema, new RecordDataType(recordSchema), fileFormat);
    }

    private static class UUIDDataType
    extends DataType {
        private final FileFormat fileFormat;

        UUIDDataType(DataType dataType, FileFormat fileFormat) {
            super(dataType.getFieldType(), dataType.getFormat());
            this.fileFormat = fileFormat;
        }

        public FileFormat getFileFormat() {
            return this.fileFormat;
        }
    }

    public static class IcebergPartnerAccessors
    implements SchemaWithPartnerVisitor.PartnerAccessors<DataType> {
        private final FileFormat fileFormat;

        IcebergPartnerAccessors(FileFormat fileFormat) {
            this.fileFormat = fileFormat;
        }

        public DataType fieldPartner(DataType dataType, int fieldId, String name) {
            Validate.isTrue((boolean)(dataType instanceof RecordDataType), (String)String.format("Invalid record: %s is not a record", dataType));
            RecordDataType recordType = (RecordDataType)dataType;
            Optional recordField = recordType.getChildSchema().getField(name);
            Validate.isTrue((boolean)recordField.isPresent(), (String)String.format("Cannot find record field with name %s", name));
            RecordField field = (RecordField)recordField.get();
            if (field.getDataType().getFieldType().equals((Object)RecordFieldType.UUID)) {
                return new UUIDDataType(field.getDataType(), this.fileFormat);
            }
            return field.getDataType();
        }

        public DataType mapKeyPartner(DataType dataType) {
            return RecordFieldType.STRING.getDataType();
        }

        public DataType mapValuePartner(DataType dataType) {
            Validate.isTrue((boolean)(dataType instanceof MapDataType), (String)String.format("Invalid map: %s is not a map", dataType));
            MapDataType mapType = (MapDataType)dataType;
            return mapType.getValueType();
        }

        public DataType listElementPartner(DataType dataType) {
            Validate.isTrue((boolean)(dataType instanceof ArrayDataType), (String)String.format("Invalid array: %s is not an array", dataType));
            ArrayDataType arrayType = (ArrayDataType)dataType;
            return arrayType.getElementType();
        }
    }

    private static class IcebergSchemaVisitor
    extends SchemaWithPartnerVisitor<DataType, DataConverter<?, ?>> {
        private IcebergSchemaVisitor() {
        }

        public static DataConverter<?, ?> visit(Schema schema, RecordDataType recordDataType, FileFormat fileFormat) {
            return (DataConverter)IcebergSchemaVisitor.visit((Schema)schema, (Object)recordDataType, (SchemaWithPartnerVisitor)new IcebergSchemaVisitor(), (SchemaWithPartnerVisitor.PartnerAccessors)new IcebergPartnerAccessors(fileFormat));
        }

        public DataConverter<?, ?> schema(Schema schema, DataType dataType, DataConverter<?, ?> converter) {
            return converter;
        }

        public DataConverter<?, ?> field(Types.NestedField field, DataType dataType, DataConverter<?, ?> converter) {
            return converter;
        }

        public DataConverter<?, ?> primitive(Type.PrimitiveType type, DataType dataType) {
            if (type.typeId() != null) {
                switch (type.typeId()) {
                    case BOOLEAN: 
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DATE: 
                    case STRING: {
                        return GenericDataConverters.SameTypeConverter.INSTANCE;
                    }
                    case TIME: {
                        return GenericDataConverters.TimeConverter.INSTANCE;
                    }
                    case TIMESTAMP: {
                        Types.TimestampType timestampType = (Types.TimestampType)type;
                        if (timestampType.shouldAdjustToUTC()) {
                            return GenericDataConverters.TimestampWithTimezoneConverter.INSTANCE;
                        }
                        return GenericDataConverters.TimestampConverter.INSTANCE;
                    }
                    case UUID: {
                        UUIDDataType uuidType = (UUIDDataType)dataType;
                        if (uuidType.getFileFormat() == FileFormat.PARQUET) {
                            return GenericDataConverters.UUIDtoByteArrayConverter.INSTANCE;
                        }
                        return GenericDataConverters.SameTypeConverter.INSTANCE;
                    }
                    case FIXED: {
                        Types.FixedType fixedType = (Types.FixedType)type;
                        return new GenericDataConverters.FixedConverter(fixedType.length());
                    }
                    case BINARY: {
                        return GenericDataConverters.BinaryConverter.INSTANCE;
                    }
                    case DECIMAL: {
                        Types.DecimalType decimalType = (Types.DecimalType)type;
                        return new GenericDataConverters.BigDecimalConverter(decimalType.precision(), decimalType.scale());
                    }
                }
                throw new UnsupportedOperationException("Unsupported type: " + type.typeId());
            }
            throw new UnsupportedOperationException("Missing type id from PrimitiveType " + type);
        }

        public DataConverter<?, ?> struct(Types.StructType type, DataType dataType, List<DataConverter<?, ?>> converters) {
            Validate.notNull((Object)type, (String)"Can not create reader for null type");
            List recordFields = ((RecordDataType)dataType).getChildSchema().getFields();
            return new GenericDataConverters.RecordConverter(converters, recordFields, type);
        }

        public DataConverter<?, ?> list(Types.ListType listTypeInfo, DataType dataType, DataConverter<?, ?> converter) {
            return new GenericDataConverters.ArrayConverter(converter, ((ArrayDataType)dataType).getElementType());
        }

        public DataConverter<?, ?> map(Types.MapType mapType, DataType dataType, DataConverter<?, ?> keyConverter, DataConverter<?, ?> valueConverter) {
            return new GenericDataConverters.MapConverter(keyConverter, RecordFieldType.STRING.getDataType(), valueConverter, ((MapDataType)dataType).getValueType());
        }
    }
}

