/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.converter;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.types.Types;
import org.apache.nifi.processors.iceberg.converter.ArrayElementGetter;
import org.apache.nifi.processors.iceberg.converter.DataConverter;
import org.apache.nifi.processors.iceberg.converter.RecordFieldGetter;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;

public class GenericDataConverters {

    static class RecordConverter
    implements DataConverter<Record, GenericRecord> {
        private final DataConverter<?, ?>[] converters;
        private final RecordFieldGetter.FieldGetter[] getters;
        private final Types.StructType schema;

        RecordConverter(List<DataConverter<?, ?>> converters, List<RecordField> recordFields, Types.StructType schema) {
            this.schema = schema;
            this.converters = (DataConverter[])Array.newInstance(DataConverter.class, converters.size());
            this.getters = new RecordFieldGetter.FieldGetter[converters.size()];
            for (int i = 0; i < converters.size(); ++i) {
                RecordField recordField = recordFields.get(i);
                this.converters[i] = converters.get(i);
                this.getters[i] = RecordFieldGetter.createFieldGetter(recordField.getDataType(), recordField.getFieldName(), recordField.isNullable());
            }
        }

        @Override
        public GenericRecord convert(Record data) {
            GenericRecord record = GenericRecord.create((Types.StructType)this.schema);
            for (int i = 0; i < this.converters.length; ++i) {
                record.set(i, this.convert(data, i, this.converters[i]));
            }
            return record;
        }

        private <T, S> S convert(Record record, int pos, DataConverter<T, S> converter) {
            return converter.convert(this.getters[pos].getFieldOrNull(record));
        }
    }

    static class MapConverter<K, V, L, B>
    implements DataConverter<Map<K, V>, Map<L, B>> {
        private final DataConverter<K, L> keyConverter;
        private final DataConverter<V, B> valueConverter;
        private final ArrayElementGetter.ElementGetter keyGetter;
        private final ArrayElementGetter.ElementGetter valueGetter;

        MapConverter(DataConverter<K, L> keyConverter, DataType keyType, DataConverter<V, B> valueConverter, DataType valueType) {
            this.keyConverter = keyConverter;
            this.keyGetter = ArrayElementGetter.createElementGetter(keyType);
            this.valueConverter = valueConverter;
            this.valueGetter = ArrayElementGetter.createElementGetter(valueType);
        }

        @Override
        public Map<L, B> convert(Map<K, V> data) {
            int mapSize = data.size();
            Object[] keyArray = data.keySet().toArray();
            Object[] valueArray = data.values().toArray();
            HashMap<L, B> result = new HashMap<L, B>(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                result.put(this.keyConverter.convert(this.keyGetter.getElementOrNull(keyArray, i)), this.valueConverter.convert(this.valueGetter.getElementOrNull(valueArray, i)));
            }
            return result;
        }
    }

    static class ArrayConverter<T, S>
    implements DataConverter<T[], List<S>> {
        private final DataConverter<T, S> fieldConverter;
        private final ArrayElementGetter.ElementGetter elementGetter;

        ArrayConverter(DataConverter<T, S> elementConverter, DataType dataType) {
            this.fieldConverter = elementConverter;
            this.elementGetter = ArrayElementGetter.createElementGetter(dataType);
        }

        @Override
        public List<S> convert(T[] data) {
            int numElements = data.length;
            ArrayList<S> result = new ArrayList<S>(numElements);
            for (int i = 0; i < numElements; ++i) {
                result.add(i, this.fieldConverter.convert(this.elementGetter.getElementOrNull(data, i)));
            }
            return result;
        }
    }

    static class BigDecimalConverter
    implements DataConverter<BigDecimal, BigDecimal> {
        private final int precision;
        private final int scale;

        BigDecimalConverter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public BigDecimal convert(BigDecimal data) {
            Validate.isTrue((data.scale() == this.scale ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), wrong scale: %s", (Object[])new Object[]{this.precision, this.scale, data});
            Validate.isTrue((data.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), invalid precision: %s", (Object[])new Object[]{this.precision, this.scale, data});
            return data;
        }
    }

    static class BinaryConverter
    implements DataConverter<Byte[], ByteBuffer> {
        static final BinaryConverter INSTANCE = new BinaryConverter();

        BinaryConverter() {
        }

        @Override
        public ByteBuffer convert(Byte[] data) {
            return ByteBuffer.wrap(ArrayUtils.toPrimitive((Byte[])data));
        }
    }

    static class FixedConverter
    implements DataConverter<Byte[], byte[]> {
        private final int length;

        FixedConverter(int length) {
            this.length = length;
        }

        @Override
        public byte[] convert(Byte[] data) {
            Validate.isTrue((data.length == this.length ? 1 : 0) != 0, (String)String.format("Cannot write byte array of length %s as fixed[%s]", data.length, this.length), (Object[])new Object[0]);
            return ArrayUtils.toPrimitive((Byte[])data);
        }
    }

    static class UUIDtoByteArrayConverter
    implements DataConverter<UUID, byte[]> {
        static final UUIDtoByteArrayConverter INSTANCE = new UUIDtoByteArrayConverter();

        UUIDtoByteArrayConverter() {
        }

        @Override
        public byte[] convert(UUID data) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
            byteBuffer.putLong(data.getMostSignificantBits());
            byteBuffer.putLong(data.getLeastSignificantBits());
            return byteBuffer.array();
        }
    }

    static class TimestampWithTimezoneConverter
    implements DataConverter<Timestamp, OffsetDateTime> {
        static final TimestampWithTimezoneConverter INSTANCE = new TimestampWithTimezoneConverter();

        TimestampWithTimezoneConverter() {
        }

        @Override
        public OffsetDateTime convert(Timestamp data) {
            return OffsetDateTime.ofInstant(data.toInstant(), ZoneId.of("UTC"));
        }
    }

    static class TimestampConverter
    implements DataConverter<Timestamp, LocalDateTime> {
        static final TimestampConverter INSTANCE = new TimestampConverter();

        TimestampConverter() {
        }

        @Override
        public LocalDateTime convert(Timestamp data) {
            return data.toLocalDateTime();
        }
    }

    static class TimeConverter
    implements DataConverter<Time, LocalTime> {
        static final TimeConverter INSTANCE = new TimeConverter();

        TimeConverter() {
        }

        @Override
        public LocalTime convert(Time data) {
            return data.toLocalTime();
        }
    }

    static class SameTypeConverter
    implements DataConverter<Object, Object> {
        static final SameTypeConverter INSTANCE = new SameTypeConverter();

        SameTypeConverter() {
        }

        @Override
        public Object convert(Object data) {
            return data;
        }
    }
}

