/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.converter;

import java.io.Serializable;
import java.time.ZoneId;
import javax.annotation.Nullable;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.serialization.record.util.IllegalTypeConversionException;

public class ArrayElementGetter {
    private static final String ARRAY_FIELD_NAME = "array element";

    public static ElementGetter createElementGetter(DataType dataType) {
        ElementGetter elementGetter;
        switch (dataType.getFieldType()) {
            case STRING: {
                elementGetter = (array, pos) -> DataTypeUtils.toString((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case CHAR: {
                elementGetter = (array, pos) -> DataTypeUtils.toCharacter((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case BOOLEAN: {
                elementGetter = (array, pos) -> DataTypeUtils.toBoolean((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case DECIMAL: {
                elementGetter = (array, pos) -> DataTypeUtils.toBigDecimal((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case BYTE: {
                elementGetter = (array, pos) -> DataTypeUtils.toByte((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case SHORT: {
                elementGetter = (array, pos) -> DataTypeUtils.toShort((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case INT: {
                elementGetter = (array, pos) -> DataTypeUtils.toInteger((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case DATE: {
                elementGetter = (array, pos) -> DataTypeUtils.toLocalDate((Object)array[pos], () -> DataTypeUtils.getDateTimeFormatter((String)dataType.getFormat(), (ZoneId)ZoneId.systemDefault()), (String)ARRAY_FIELD_NAME);
                break;
            }
            case TIME: {
                elementGetter = (array, pos) -> DataTypeUtils.toTime((Object)array[pos], () -> DataTypeUtils.getDateFormat((String)dataType.getFormat()), (String)ARRAY_FIELD_NAME);
                break;
            }
            case LONG: {
                elementGetter = (array, pos) -> DataTypeUtils.toLong((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case BIGINT: {
                elementGetter = (array, pos) -> DataTypeUtils.toBigInt((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case FLOAT: {
                elementGetter = (array, pos) -> DataTypeUtils.toFloat((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case DOUBLE: {
                elementGetter = (array, pos) -> DataTypeUtils.toDouble((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case TIMESTAMP: {
                elementGetter = (array, pos) -> DataTypeUtils.toTimestamp((Object)array[pos], () -> DataTypeUtils.getDateFormat((String)dataType.getFormat()), (String)ARRAY_FIELD_NAME);
                break;
            }
            case UUID: {
                elementGetter = (array, pos) -> DataTypeUtils.toUUID((Object)array[pos]);
                break;
            }
            case ARRAY: {
                elementGetter = (array, pos) -> DataTypeUtils.toArray((Object)array[pos], (String)ARRAY_FIELD_NAME, (DataType)((ArrayDataType)dataType).getElementType());
                break;
            }
            case MAP: {
                elementGetter = (array, pos) -> DataTypeUtils.toMap((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case RECORD: {
                elementGetter = (array, pos) -> DataTypeUtils.toRecord((Object)array[pos], (String)ARRAY_FIELD_NAME);
                break;
            }
            case CHOICE: {
                elementGetter = (array, pos) -> {
                    ChoiceDataType choiceDataType = (ChoiceDataType)dataType;
                    DataType chosenDataType = DataTypeUtils.chooseDataType((Object)array[pos], (ChoiceDataType)choiceDataType);
                    if (chosenDataType == null) {
                        throw new IllegalTypeConversionException(String.format("Cannot convert value [%s] of type %s for array element to any of the following available Sub-Types for a Choice: %s", array[pos], array[pos].getClass(), choiceDataType.getPossibleSubTypes()));
                    }
                    return DataTypeUtils.convertType((Object)array[pos], (DataType)chosenDataType, (String)ARRAY_FIELD_NAME);
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported field type: " + dataType.getFieldType());
            }
        }
        return (array, pos) -> {
            if (array[pos] == null) {
                return null;
            }
            return elementGetter.getElementOrNull(array, pos);
        };
    }

    public static interface ElementGetter
    extends Serializable {
        @Nullable
        public Object getElementOrNull(Object[] var1, int var2);
    }
}

