/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.iceberg.PutIceberg;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosUser;
import org.apache.nifi.services.iceberg.IcebergCatalogService;

public abstract class AbstractIcebergProcessor
extends AbstractProcessor {
    static final PropertyDescriptor CATALOG = new PropertyDescriptor.Builder().name("catalog-service").displayName("Catalog Service").description("Specifies the Controller Service to use for handling references to table\u2019s metadata files.").identifiesControllerService(IcebergCatalogService.class).required(true).build();
    static final PropertyDescriptor KERBEROS_USER_SERVICE = new PropertyDescriptor.Builder().name("kerberos-user-service").displayName("Kerberos User Service").description("Specifies the Kerberos User Controller Service that should be used for authenticating with Kerberos.").identifiesControllerService(KerberosUserService.class).build();
    private volatile KerberosUser kerberosUser;
    private volatile UserGroupInformation ugi;

    @OnScheduled
    public final void onScheduled(ProcessContext context) {
        IcebergCatalogService catalogService = (IcebergCatalogService)context.getProperty(CATALOG).asControllerService(IcebergCatalogService.class);
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        if (kerberosUserService != null) {
            this.kerberosUser = kerberosUserService.createKerberosUser();
            try {
                this.ugi = SecurityUtil.getUgiForKerberosUser((Configuration)catalogService.getConfiguration(), (KerberosUser)this.kerberosUser);
            }
            catch (IOException e) {
                throw new ProcessException("Kerberos Authentication failed", (Throwable)e);
            }
        }
    }

    @OnStopped
    public final void onStopped() {
        if (this.kerberosUser != null) {
            try {
                this.kerberosUser.logout();
            }
            catch (KerberosLoginException e) {
                this.getLogger().error("Error logging out kerberos user", (Throwable)e);
            }
            finally {
                this.kerberosUser = null;
                this.ugi = null;
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        if (this.kerberosUser == null) {
            this.doOnTrigger(context, session, flowFile);
        } else {
            try {
                this.getUgi().doAs(() -> {
                    this.doOnTrigger(context, session, flowFile);
                    return null;
                });
            }
            catch (Exception e) {
                this.getLogger().error("Privileged action failed with kerberos user " + this.kerberosUser, (Throwable)e);
                session.transfer(flowFile, PutIceberg.REL_FAILURE);
            }
        }
    }

    private UserGroupInformation getUgi() {
        try {
            this.kerberosUser.checkTGTAndRelogin();
        }
        catch (KerberosLoginException e) {
            throw new ProcessException("Unable to re-login with kerberos credentials for " + this.kerberosUser.getPrincipal(), (Throwable)e);
        }
        return this.ugi;
    }

    protected abstract void doOnTrigger(ProcessContext var1, ProcessSession var2, FlowFile var3) throws ProcessException;
}

