/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.headless;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.cluster.ClusterDetailsFactory;
import org.apache.nifi.cluster.ConnectionState;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.controller.DecommissionTask;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.StandardFlowService;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.metrics.RingBufferEventRepository;
import org.apache.nifi.controller.state.manager.StandardStateManagerProvider;
import org.apache.nifi.controller.status.history.StatusHistoryDumpFactory;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.diagnostics.DiagnosticsDump;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.DiagnosticsFactory;
import org.apache.nifi.diagnostics.ThreadDumpTask;
import org.apache.nifi.diagnostics.bootstrap.BootstrapDiagnosticsFactory;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptorBuilder;
import org.apache.nifi.events.VolatileBulletinRepository;
import org.apache.nifi.framework.ssl.FrameworkSslContextProvider;
import org.apache.nifi.headless.HeadlessAuditService;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.ExtensionManagerHolder;
import org.apache.nifi.nar.ExtensionMapping;
import org.apache.nifi.nar.NarAutoLoader;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.StandardExtensionDiscoveringManager;
import org.apache.nifi.nar.StandardNarLoader;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.FlowParser;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadlessNiFiServer
implements NiFiServer {
    private static final String DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION = "org.apache.nifi.controller.status.history.VolatileComponentStatusRepository";
    private static final Logger logger = LoggerFactory.getLogger(HeadlessNiFiServer.class);
    private NiFiProperties props;
    private Bundle systemBundle;
    private Set<Bundle> bundles;
    private FlowController flowController;
    private FlowService flowService;
    private DiagnosticsFactory diagnosticsFactory;
    private NarAutoLoader narAutoLoader;

    public void start() {
        try {
            StandardExtensionDiscoveringManager extensionManager = new StandardExtensionDiscoveringManager();
            extensionManager.discoverExtensions(this.systemBundle, this.bundles);
            extensionManager.logClassLoaderMapping();
            ExtensionManagerHolder.init((ExtensionManager)extensionManager);
            new FlowParser();
            logger.info("Loading Flow...");
            RingBufferEventRepository flowFileEventRepository = new RingBufferEventRepository(5);
            HeadlessAuditService auditService = new HeadlessAuditService();
            Authorizer authorizer = new Authorizer(this){

                public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
                    return AuthorizationResult.approved();
                }

                public void initialize(AuthorizerInitializationContext initializationContext) throws AuthorizerCreationException {
                }

                public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
                }

                public void preDestruction() throws AuthorizerDestructionException {
                }
            };
            String propertiesKey = this.props.getProperty("nifi.sensitive.props.key");
            String propertiesAlgorithm = this.props.getProperty("nifi.sensitive.props.algorithm");
            PropertyEncryptor encryptor = new PropertyEncryptorBuilder(propertiesKey).setAlgorithm(propertiesAlgorithm).build();
            VolatileBulletinRepository bulletinRepository = new VolatileBulletinRepository();
            StatusHistoryRepository statusHistoryRepository = this.getStatusHistoryRepository((ExtensionManager)extensionManager);
            FrameworkSslContextProvider sslContextProvider = new FrameworkSslContextProvider(this.props);
            SSLContext sslContext = sslContextProvider.loadSslContext().orElse(null);
            StateManagerProvider stateManagerProvider = StandardStateManagerProvider.create((NiFiProperties)this.props, (SSLContext)sslContext, (ExtensionManager)extensionManager, (ParameterLookup)ParameterLookup.EMPTY);
            this.flowController = FlowController.createStandaloneInstance((FlowFileEventRepository)flowFileEventRepository, (SSLContext)sslContext, (NiFiProperties)this.props, (Authorizer)authorizer, (AuditService)auditService, (PropertyEncryptor)encryptor, (BulletinRepository)bulletinRepository, (ExtensionDiscoveringManager)extensionManager, (StatusHistoryRepository)statusHistoryRepository, null, (StateManagerProvider)stateManagerProvider);
            this.flowService = StandardFlowService.createStandaloneInstance((FlowController)this.flowController, (NiFiProperties)this.props, null, null, null, (Authorizer)authorizer);
            this.diagnosticsFactory = new BootstrapDiagnosticsFactory();
            ((BootstrapDiagnosticsFactory)this.diagnosticsFactory).setFlowController(this.flowController);
            ((BootstrapDiagnosticsFactory)this.diagnosticsFactory).setNifiProperties(this.props);
            this.flowService.start();
            this.flowService.load(null);
            this.flowController.onFlowInitialized(true);
            this.validateFlow();
            FlowManager flowManager = this.flowController.getFlowManager();
            flowManager.getGroup(flowManager.getRootGroupId()).startProcessing();
            NarUnpackMode unpackMode = this.props.isUnpackNarsToUberJar() ? NarUnpackMode.UNPACK_TO_UBER_JAR : NarUnpackMode.UNPACK_INDIVIDUAL_JARS;
            StandardNarLoader narLoader = new StandardNarLoader(this.props.getExtensionsWorkingDirectory(), NarClassLoadersHolder.getInstance(), (ExtensionDiscoveringManager)extensionManager, new ExtensionMapping(), null, unpackMode);
            this.narAutoLoader = new NarAutoLoader(this.props, (NarLoader)narLoader);
            this.narAutoLoader.start();
            logger.info("Flow loaded successfully.");
        }
        catch (Exception e) {
            if (this.flowService != null && this.flowService.isRunning()) {
                this.flowService.stop(false);
            }
            this.startUpFailure(new Exception("Unable to load flow due to: " + String.valueOf(e), e));
        }
    }

    protected void validateFlow() {
        logger.info("Flow validation not implemented. Proceeding without validating the flow");
    }

    private void startUpFailure(Throwable t) {
        System.err.println("Failed to start flow service: " + t.getMessage());
        System.err.println("Shutting down...");
        logger.warn("Failed to start headless server... shutting down.", t);
        System.exit(1);
    }

    private StatusHistoryRepository getStatusHistoryRepository(ExtensionManager extensionManager) {
        String implementationClassName = this.props.getProperty("nifi.components.status.repository.implementation", DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION);
        try {
            StatusHistoryRepository repository = (StatusHistoryRepository)NarThreadContextClassLoader.createInstance((ExtensionManager)extensionManager, (String)implementationClassName, StatusHistoryRepository.class, (NiFiProperties)this.props);
            repository.start();
            return repository;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize(NiFiProperties properties, Bundle systemBundle, Set<Bundle> bundles, ExtensionMapping extensionMapping) {
        this.props = properties;
        this.systemBundle = systemBundle;
        this.bundles = bundles;
    }

    public DiagnosticsFactory getDiagnosticsFactory() {
        return this.diagnosticsFactory == null ? this.getThreadDumpFactory() : this.diagnosticsFactory;
    }

    public DiagnosticsFactory getThreadDumpFactory() {
        return new ThreadDumpDiagnosticsFactory();
    }

    public DecommissionTask getDecommissionTask() {
        return null;
    }

    public ClusterDetailsFactory getClusterDetailsFactory() {
        return () -> ConnectionState.NOT_CLUSTERED;
    }

    public StatusHistoryDumpFactory getStatusHistoryDumpFactory() {
        return null;
    }

    public void stop() {
        try {
            this.flowService.stop(false);
            try {
                if (this.narAutoLoader != null) {
                    this.narAutoLoader.stop();
                    this.narAutoLoader = null;
                }
            }
            catch (Exception e) {
                logger.warn("Failed to stop NAR auto-loader", (Throwable)e);
            }
        }
        catch (Exception e) {
            String msg = "Problem occurred ensuring flow controller or repository was properly terminated due to " + String.valueOf(e);
            if (logger.isDebugEnabled()) {
                logger.warn(msg, (Throwable)e);
            }
            logger.warn(msg);
        }
    }

    protected FlowController getFlowController() {
        return this.flowController;
    }

    protected FlowService getFlowService() {
        return this.flowService;
    }

    protected NiFiProperties getNiFiProperties() {
        return this.props;
    }

    protected List<Bundle> getBundles(String bundleClass) {
        return ExtensionManagerHolder.getExtensionManager().getBundles(bundleClass);
    }

    private static class ThreadDumpDiagnosticsFactory
    implements DiagnosticsFactory {
        private ThreadDumpDiagnosticsFactory() {
        }

        public DiagnosticsDump create(boolean verbose) {
            return out -> {
                DiagnosticsDumpElement threadDumpElement = new ThreadDumpTask().captureDump(verbose);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
                for (String detail : threadDumpElement.getDetails()) {
                    writer.write(detail);
                    writer.write("\n");
                }
                writer.flush();
            };
        }
    }
}

