/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util.writer;

import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.hadoop.util.FileStatusIterable;
import org.apache.nifi.processors.hadoop.util.FileStatusManager;
import org.apache.nifi.processors.hadoop.util.writer.HadoopFileStatusWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class RecordHadoopFileStatusWriter
extends HadoopFileStatusWriter {
    private static final RecordSchema RECORD_SCHEMA;
    private static final String FILENAME = "filename";
    private static final String PATH = "path";
    private static final String IS_DIRECTORY = "directory";
    private static final String SIZE = "size";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String PERMISSIONS = "permissions";
    private static final String OWNER = "owner";
    private static final String GROUP = "group";
    private static final String REPLICATION = "replication";
    private static final String IS_SYM_LINK = "symLink";
    private static final String IS_ENCRYPTED = "encrypted";
    private static final String IS_ERASURE_CODED = "erasureCoded";

    public RecordHadoopFileStatusWriter(ProcessSession session, Relationship successRelationship, FileStatusIterable fileStatusIterable, FileStatusManager fileStatusManager, PathFilter pathFilter, long minimumAge, long maximumAge, long previousLatestTimestamp, List<String> previousLatestFiles, RecordSetWriterFactory writerFactory, String hdfsPrefix, ComponentLog logger) {
        super(session, successRelationship, fileStatusIterable, fileStatusManager, pathFilter, minimumAge, maximumAge, previousLatestTimestamp, previousLatestFiles, writerFactory, hdfsPrefix, logger);
    }

    @Override
    public void write() {
        WriteResult writeResult;
        String mimeType;
        FlowFile flowFile = this.session.create();
        try (OutputStream out = this.session.write(flowFile);
             RecordSetWriter recordWriter = this.writerFactory.createWriter(this.logger, RECORD_SCHEMA, out, flowFile);){
            mimeType = recordWriter.getMimeType();
            recordWriter.beginRecordSet();
            for (FileStatus status : this.fileStatusIterable) {
                if (!this.determineListable(status)) continue;
                recordWriter.write(this.createRecordForListing(status));
                this.fileStatusManager.update(status);
            }
            writeResult = recordWriter.finishRecordSet();
        }
        catch (Exception e) {
            throw new ProcessException("An error occurred while writing results", (Throwable)e);
        }
        this.fileCount = writeResult.getRecordCount();
        if (this.fileCount == 0L) {
            this.session.remove(flowFile);
        } else {
            HashMap<String, String> attributes = new HashMap<String, String>(writeResult.getAttributes());
            attributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
            attributes.put(CoreAttributes.MIME_TYPE.key(), mimeType);
            flowFile = this.session.putAllAttributes(flowFile, attributes);
            this.session.transfer(flowFile, this.successRelationship);
        }
    }

    private Record createRecordForListing(FileStatus fileStatus) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(FILENAME, fileStatus.getPath().getName());
        values.put(PATH, this.getAbsolutePath(fileStatus.getPath().getParent()));
        values.put(OWNER, fileStatus.getOwner());
        values.put(GROUP, fileStatus.getGroup());
        values.put(LAST_MODIFIED, new Timestamp(fileStatus.getModificationTime()));
        values.put(SIZE, fileStatus.getLen());
        values.put(REPLICATION, fileStatus.getReplication());
        FsPermission permission = fileStatus.getPermission();
        String perms = this.getPermissionsString(permission);
        values.put(PERMISSIONS, perms);
        values.put(IS_DIRECTORY, fileStatus.isDirectory());
        values.put(IS_SYM_LINK, fileStatus.isSymlink());
        values.put(IS_ENCRYPTED, fileStatus.isEncrypted());
        values.put(IS_ERASURE_CODED, fileStatus.isErasureCoded());
        return new MapRecord(RECORD_SCHEMA, values);
    }

    static {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        recordFields.add(new RecordField(FILENAME, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(PATH, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(IS_DIRECTORY, RecordFieldType.BOOLEAN.getDataType(), false));
        recordFields.add(new RecordField(SIZE, RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField(LAST_MODIFIED, RecordFieldType.TIMESTAMP.getDataType(), false));
        recordFields.add(new RecordField(PERMISSIONS, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField(OWNER, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField(GROUP, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField(REPLICATION, RecordFieldType.INT.getDataType()));
        recordFields.add(new RecordField(IS_SYM_LINK, RecordFieldType.BOOLEAN.getDataType()));
        recordFields.add(new RecordField(IS_ENCRYPTED, RecordFieldType.BOOLEAN.getDataType()));
        recordFields.add(new RecordField(IS_ERASURE_CODED, RecordFieldType.BOOLEAN.getDataType()));
        RECORD_SCHEMA = new SimpleRecordSchema(recordFields);
    }
}

