/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processors.hadoop.SequenceFileWriterImpl;
import org.apache.nifi.processors.hadoop.util.InputStreamWritable;
import org.apache.nifi.util.FlowFilePackagerV3;
import org.slf4j.LoggerFactory;

public class FlowFileStreamUnpackerSequenceFileWriter
extends SequenceFileWriterImpl {
    @Override
    protected void processInputStream(InputStream stream, FlowFile flowFileStreamPackedFlowFile, SequenceFile.Writer writer) throws IOException {
        FlowFileUnpackager unpackager = new FlowFileUnpackager();
        try (BufferedInputStream ignored = new BufferedInputStream(stream);){
            while (unpackager.hasMoreData()) {
                unpackager.unpackageFlowFile(stream, writer);
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(FlowFileStreamUnpackerSequenceFileWriter.class);
    }

    private static class FlowFileUnpackager {
        private byte[] nextHeader = null;
        private boolean haveReadSomething = false;
        private final byte[] readBuffer = new byte[8192];

        private FlowFileUnpackager() {
        }

        public boolean hasMoreData() {
            return this.nextHeader != null || !this.haveReadSomething;
        }

        private byte[] readHeader(InputStream in) throws IOException {
            byte[] header = new byte[FlowFilePackagerV3.MAGIC_HEADER.length];
            for (int i = 0; i < header.length; ++i) {
                int next = in.read();
                if (next < 0) {
                    if (i == 0) {
                        return null;
                    }
                    throw new IOException("Not in FlowFile-v3 format");
                }
                header[i] = (byte)(next & 0xFF);
            }
            return header;
        }

        public void unpackageFlowFile(InputStream in, SequenceFile.Writer writer) throws IOException {
            byte[] header;
            byte[] byArray = header = this.nextHeader == null ? this.readHeader(in) : this.nextHeader;
            if (!Arrays.equals(header, FlowFilePackagerV3.MAGIC_HEADER)) {
                throw new IOException("Not in FlowFile-v3 format");
            }
            Map<String, String> attributes = this.readAttributes(in);
            long expectedNumBytes = this.readLong(in);
            InputStreamWritable inStreamWritable = new InputStreamWritable(in, (int)expectedNumBytes);
            String fileName = attributes.get(CoreAttributes.FILENAME.key());
            Text key = new Text(fileName);
            writer.append((Writable)key, (Writable)inStreamWritable);
            this.nextHeader = this.readHeader(in);
            this.haveReadSomething = true;
        }

        protected Map<String, String> readAttributes(InputStream in) throws IOException {
            HashMap<String, String> attributes = new HashMap<String, String>();
            Integer numAttributes = this.readFieldLength(in);
            if (numAttributes == null) {
                return null;
            }
            if (numAttributes == 0) {
                throw new IOException("flow files cannot have zero attributes");
            }
            for (int i = 0; i < numAttributes; ++i) {
                String key = this.readString(in);
                String value = this.readString(in);
                attributes.put(key, value);
            }
            return attributes;
        }

        protected String readString(InputStream in) throws IOException {
            Integer numBytes = this.readFieldLength(in);
            if (numBytes == null) {
                throw new EOFException();
            }
            byte[] bytes = new byte[numBytes.intValue()];
            this.fillBuffer(in, bytes, numBytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }

        private void fillBuffer(InputStream in, byte[] buffer, int length) throws IOException {
            int bytesRead;
            int totalBytesRead = 0;
            while ((bytesRead = in.read(buffer, totalBytesRead, length - totalBytesRead)) > 0) {
                totalBytesRead += bytesRead;
            }
            if (totalBytesRead != length) {
                throw new EOFException();
            }
        }

        protected long readLong(InputStream in) throws IOException {
            this.fillBuffer(in, this.readBuffer, 8);
            return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)(this.readBuffer[7] & 0xFF);
        }

        private Integer readFieldLength(InputStream in) throws IOException {
            int firstValue = in.read();
            int secondValue = in.read();
            if (firstValue < 0) {
                return null;
            }
            if (secondValue < 0) {
                throw new EOFException();
            }
            if (firstValue == 255 && secondValue == 255) {
                int ch4;
                int ch3;
                int ch2;
                int ch1 = in.read();
                if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
                    throw new EOFException();
                }
                return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
            }
            return (firstValue << 8) + secondValue;
        }
    }
}

