/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hazelcast.services.cachemanager;

import com.hazelcast.core.HazelcastInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hazelcast.services.cachemanager.IMapBasedHazelcastCacheManager;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"hazelcast", "cache"})
@CapabilityDescription(value="A service that provides cache instances backed by Hazelcast running outside of NiFi.")
public class ExternalHazelcastCacheManager
extends IMapBasedHazelcastCacheManager {
    public static final PropertyDescriptor HAZELCAST_SERVER_ADDRESS = new PropertyDescriptor.Builder().name("hazelcast-server-address").displayName("Hazelcast Server Address").description("Addresses of one or more the Hazelcast instances, using {host:port} format, separated by comma.").required(true).addValidator(StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor HAZELCAST_RETRY_BACKOFF_INITIAL = new PropertyDescriptor.Builder().name("hazelcast-retry-backoff-initial").displayName("Hazelcast Initial Backoff").description("The amount of time the client waits before it tries to reestablish connection for the first time.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).defaultValue("1 secs").build();
    public static final PropertyDescriptor HAZELCAST_RETRY_BACKOFF_MAXIMUM = new PropertyDescriptor.Builder().name("hazelcast-retry-backoff-maximum").displayName("Hazelcast Maximum Backoff").description("The maximum amount of time the client waits before it tries to reestablish connection.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).defaultValue("5 secs").build();
    public static final PropertyDescriptor HAZELCAST_RETRY_BACKOFF_MULTIPLIER = new PropertyDescriptor.Builder().name("hazelcast-retry-backoff-multiplier").displayName("Hazelcast Backoff Multiplier").description("A multiplier by which the wait time is increased before each attempt to reestablish connection.").addValidator(StandardValidators.NUMBER_VALIDATOR).required(true).defaultValue(String.valueOf(1.5)).build();
    public static final PropertyDescriptor HAZELCAST_CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("hazelcast-connection-timeout").displayName("Hazelcast Connection Timeout").description("The maximum amount of time the client tries to connect or reconnect before giving up.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).defaultValue("20 secs").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS;

    @Override
    protected HazelcastInstance getInstance(ConfigurationContext context) {
        return this.getClientInstance(context.getProperty(HAZELCAST_CLUSTER_NAME).evaluateAttributeExpressions().getValue(), Arrays.asList(context.getProperty(HAZELCAST_SERVER_ADDRESS).evaluateAttributeExpressions().getValue().split(",")), context.getProperty(HAZELCAST_CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS), context.getProperty(HAZELCAST_RETRY_BACKOFF_INITIAL).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), context.getProperty(HAZELCAST_RETRY_BACKOFF_MAXIMUM).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), context.getProperty(HAZELCAST_RETRY_BACKOFF_MULTIPLIER).asDouble());
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        if (context.getProperty(HAZELCAST_RETRY_BACKOFF_INITIAL).asTimePeriod(TimeUnit.MILLISECONDS).compareTo((Long)Integer.MAX_VALUE) > 0) {
            results.add(new ValidationResult.Builder().subject(HAZELCAST_RETRY_BACKOFF_INITIAL.getDisplayName()).valid(false).explanation("millisecond representation of initial backoff time must not be above 2147483647!").build());
        }
        if (context.getProperty(HAZELCAST_RETRY_BACKOFF_MAXIMUM).asTimePeriod(TimeUnit.MILLISECONDS).compareTo((Long)Integer.MAX_VALUE) > 0) {
            results.add(new ValidationResult.Builder().subject(HAZELCAST_RETRY_BACKOFF_MAXIMUM.getDisplayName()).valid(false).explanation("millisecond representation of maximum backoff time must not be above 2147483647!").build());
        }
        return results;
    }

    static {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(HAZELCAST_CLUSTER_NAME);
        properties.add(HAZELCAST_SERVER_ADDRESS);
        properties.add(HAZELCAST_RETRY_BACKOFF_INITIAL);
        properties.add(HAZELCAST_RETRY_BACKOFF_MAXIMUM);
        properties.add(HAZELCAST_RETRY_BACKOFF_MULTIPLIER);
        properties.add(HAZELCAST_CONNECTION_TIMEOUT);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properties);
    }
}

