/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dbcp.AbstractDBCPConnectionPool;
import org.apache.nifi.dbcp.ValidationResources;
import org.apache.nifi.dbcp.utils.DBCPProperties;
import org.apache.nifi.dbcp.utils.DataSourceConfiguration;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@RequiresInstanceClassLoading
@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store", "hadoop"})
@CapabilityDescription(value="Provides a Database Connection Pooling Service for Hadoop related JDBC services. This service requires that the Database Driver Location(s) contains some version of a hadoop-common JAR, or a shaded JAR that shades hadoop-common.")
@DynamicProperty(name="The name of a Hadoop configuration property.", value="The value of the given Hadoop configuration property.", description="These properties will be set on the Hadoop configuration after loading any provided configuration files.", expressionLanguageScope=ExpressionLanguageScope.ENVIRONMENT)
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.REFERENCE_REMOTE_RESOURCES, explanation="Database Driver Location can reference resources over HTTP")})
public class HadoopDBCPConnectionPool
extends AbstractDBCPConnectionPool {
    private static final String HADOOP_CONFIGURATION_CLASS = "org.apache.hadoop.conf.Configuration";
    private static final String HADOOP_UGI_CLASS = "org.apache.hadoop.security.UserGroupInformation";
    public static final PropertyDescriptor DB_DRIVER_LOCATION = new PropertyDescriptor.Builder().fromPropertyDescriptor(DBCPProperties.DB_DRIVER_LOCATION).description("Comma-separated list of files/folders and/or URLs containing the driver JAR and its dependencies. For example '/var/tmp/phoenix-client.jar'. NOTE: It is required that the resources specified by this property provide the classes from hadoop-common, such as Configuration and UserGroupInformation.").required(true).build();
    public static final PropertyDescriptor HADOOP_CONFIGURATION_RESOURCES = new PropertyDescriptor.Builder().name("hadoop-config-resources").displayName("Hadoop Configuration Resources").description("A file, or comma separated list of files, which contain the Hadoop configuration (core-site.xml, etc.). Without this, Hadoop will search the classpath, or will revert to a default configuration. Note that to enable authentication with Kerberos, the appropriate properties must be set in the configuration files.").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamicallyModifiesClasspath(true).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(DBCPProperties.DATABASE_URL, DBCPProperties.DB_DRIVERNAME, DB_DRIVER_LOCATION, HADOOP_CONFIGURATION_RESOURCES, DBCPProperties.KERBEROS_USER_SERVICE, DBCPProperties.DB_USER, DBCPProperties.DB_PASSWORD, DBCPProperties.MAX_WAIT_TIME, DBCPProperties.MAX_TOTAL_CONNECTIONS, DBCPProperties.VALIDATION_QUERY, DBCPProperties.MIN_IDLE, DBCPProperties.MAX_IDLE, DBCPProperties.MAX_CONN_LIFETIME, DBCPProperties.EVICTION_RUN_PERIOD, DBCPProperties.MIN_EVICTABLE_IDLE_TIME, DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME);
    private volatile Boolean foundHadoopDependencies;
    private final AtomicReference<ValidationResources> validationResourceHolder = new AtomicReference<Object>(null);

    public void migrateProperties(PropertyConfiguration config) {
        config.removeProperty("Kerberos Principal");
        config.removeProperty("Kerberos Password");
        config.removeProperty("Kerberos Keytab");
        config.removeProperty("kerberos-credentials-service");
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        if (this.foundHadoopDependencies == null) {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            try {
                Class.forName(HADOOP_CONFIGURATION_CLASS, true, classLoader);
                Class.forName(HADOOP_UGI_CLASS, true, classLoader);
                this.foundHadoopDependencies = true;
            }
            catch (ClassNotFoundException cnf) {
                this.getLogger().debug(cnf.getMessage(), (Throwable)cnf);
                this.foundHadoopDependencies = false;
            }
        }
        if (!this.foundHadoopDependencies.booleanValue()) {
            problems.add(new ValidationResult.Builder().subject(DB_DRIVER_LOCATION.getDisplayName()).valid(false).explanation("required Hadoop classes were not found in any of the specified resources, please ensure that hadoop-common is available").build());
            return problems;
        }
        boolean confFileProvided = validationContext.getProperty(HADOOP_CONFIGURATION_RESOURCES).isSet();
        if (confFileProvided) {
            String configFiles = validationContext.getProperty(HADOOP_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
            ValidationResources resources = this.validationResourceHolder.get();
            if (resources == null || !configFiles.equals(resources.getConfigResources())) {
                this.getLogger().debug("Reloading validation resources");
                resources = new ValidationResources(configFiles, this.getConfigurationFromFiles(configFiles));
                this.validationResourceHolder.set(resources);
            }
        }
        return problems;
    }

    protected Configuration getConfigurationFromFiles(String configFiles) {
        Configuration conf = new Configuration();
        if (StringUtils.isNotBlank((CharSequence)configFiles)) {
            for (String configFile : configFiles.split(",")) {
                conf.addResource(new Path(configFile.trim()));
            }
        }
        return conf;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        String configFiles = context.getProperty(HADOOP_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
        Configuration hadoopConfig = this.getConfigurationFromFiles(configFiles);
        for (Map.Entry entry : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (!descriptor.isDynamic()) continue;
            hadoopConfig.set(descriptor.getName(), context.getProperty(descriptor).evaluateAttributeExpressions().getValue());
        }
    }

    @OnDisabled
    public void shutdown() throws SQLException {
        this.validationResourceHolder.set(null);
        this.foundHadoopDependencies = null;
        this.kerberosUser = null;
        try {
            if (this.dataSource != null) {
                this.dataSource.close();
            }
        }
        finally {
            this.dataSource = null;
        }
    }

    protected Driver getDriver(String driverName, String url) {
        Class<?> clazz;
        try {
            clazz = Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new ProcessException("Driver class " + driverName + " is not found", (Throwable)e);
        }
        try {
            return DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            try {
                Driver driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DriverManager.registerDriver(driver);
                return DriverManager.getDriver(url);
            }
            catch (SQLException e2) {
                throw new ProcessException("No suitable driver for the given Database Connection URL", (Throwable)e2);
            }
            catch (Exception e2) {
                throw new ProcessException("Creating driver instance is failed", (Throwable)e2);
            }
        }
    }

    protected DataSourceConfiguration getDataSourceConfiguration(ConfigurationContext context) {
        String url = context.getProperty(DBCPProperties.DATABASE_URL).evaluateAttributeExpressions().getValue();
        String driverName = context.getProperty(DBCPProperties.DB_DRIVERNAME).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(DBCPProperties.DB_USER).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(DBCPProperties.DB_PASSWORD).evaluateAttributeExpressions().getValue();
        Integer maxTotal = context.getProperty(DBCPProperties.MAX_TOTAL_CONNECTIONS).evaluateAttributeExpressions().asInteger();
        String validationQuery = context.getProperty(DBCPProperties.VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        Long maxWaitMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_WAIT_TIME).evaluateAttributeExpressions());
        Integer minIdle = context.getProperty(DBCPProperties.MIN_IDLE).evaluateAttributeExpressions().asInteger();
        Integer maxIdle = context.getProperty(DBCPProperties.MAX_IDLE).evaluateAttributeExpressions().asInteger();
        Long maxConnLifetimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_CONN_LIFETIME).evaluateAttributeExpressions());
        Long timeBetweenEvictionRunsMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.EVICTION_RUN_PERIOD).evaluateAttributeExpressions());
        Long minEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        Long softMinEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        return new DataSourceConfiguration.Builder(url, driverName, user, password).validationQuery(validationQuery).maxWaitMillis(maxWaitMillis.longValue()).maxTotal(maxTotal.intValue()).minIdle(minIdle.intValue()).maxIdle(maxIdle.intValue()).maxConnLifetimeMillis(maxConnLifetimeMillis.longValue()).timeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue()).minEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue()).softMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis.longValue()).build();
    }

    public Connection getConnection() throws ProcessException {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public String toString() {
        return "HadoopDBCPConnectionPool[id=" + this.getIdentifier() + "]";
    }
}

