/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.groovyx.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

public class Throwables {
    public static String stringStackTrace(Throwable e) {
        StringWriter sw = new StringWriter(500);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static String getMessage(Throwable e) {
        return Throwables.getMessage(e, null, -1);
    }

    public static String getMessage(Throwable e, Object priority, int maxlen) {
        Object msg;
        int i;
        if (e == null) {
            return null;
        }
        e = Throwables.getRootException(e);
        StackTraceElement[] trace = e.getStackTrace();
        int traceIndex = -1;
        if (priority != null) {
            if (priority instanceof String) {
                for (i = 0; i < trace.length; ++i) {
                    if (!trace[i].getClassName().startsWith((String)((Object)priority))) continue;
                    traceIndex = i;
                    break;
                }
            } else {
                int i2;
                if (!(priority instanceof Class)) {
                    priority = priority.getClass();
                }
                String cl = ((Class)priority).getName();
                for (i2 = 0; i2 < trace.length; ++i2) {
                    if (!trace[i2].getClassName().startsWith(cl)) continue;
                    traceIndex = i2;
                    break;
                }
                if (traceIndex == -1) {
                    cl = priority.getPackage().getName();
                    for (i2 = 0; i2 < trace.length; ++i2) {
                        if (!trace[i2].getClassName().startsWith(cl)) continue;
                        traceIndex = i2;
                        break;
                    }
                }
            }
        }
        if (traceIndex == -1) {
            for (i = 0; i < trace.length; ++i) {
                String cl = trace[i].getClassName();
                if (cl.startsWith("java.") || cl.startsWith("javax.") || cl.startsWith("org.omg.") || cl.startsWith("org.w3c.") || cl.startsWith("org.xml.") || cl.startsWith("groovy.lang.") || cl.startsWith("groovy.util.") || cl.startsWith("org.codehaus.") || cl.startsWith("com.springsource.") || cl.startsWith("org.springframework.") || cl.startsWith("org.apache.") || cl.startsWith("sun.") || cl.startsWith("com.sun.") || cl.startsWith("org.junit.") || cl.startsWith("junit.framework.")) continue;
                traceIndex = i;
                break;
            }
        }
        if (traceIndex == -1) {
            traceIndex = 0;
        }
        if ((msg = e.getMessage()) == null) {
            msg = "";
        }
        if (((String)(msg = ((String)msg).trim())).length() > 0 && ".!:,;?".indexOf(((String)msg).substring(((String)msg).length() - 1)) == -1) {
            msg = (String)msg + ".";
        }
        Object msgSuffix = " " + e.getClass().getName().replaceAll("^.*\\.(\\w+)$", "$1") + " at ";
        if (traceIndex < 0 || traceIndex >= trace.length) {
            System.err.println("Error formatting exception: " + String.valueOf(e));
            e.printStackTrace(System.err);
            msgSuffix = e.getClass().getName();
        } else {
            msgSuffix = (String)msgSuffix + trace[traceIndex].toString();
        }
        if (maxlen > 0 && ((String)msgSuffix).length() + ((String)msg).length() > maxlen) {
            if (maxlen > ((String)msgSuffix).length() + 2) {
                int newlen = maxlen - ((String)msgSuffix).length() - 2;
                if (newlen < ((String)msg).length()) {
                    msg = ((String)msg).substring(0, newlen);
                }
                msg = (String)msg + ".." + (String)msgSuffix;
            } else if (((String)msg).length() > maxlen) {
                msg = ((String)msg).substring(0, maxlen);
            }
        } else {
            msg = (String)msg + (String)msgSuffix;
        }
        return msg;
    }

    private static Throwable getRootException(Throwable e) {
        Throwable t;
        if (e instanceof InvocationTargetException) {
            t = ((InvocationTargetException)e).getTargetException();
        } else if (e instanceof RuntimeException) {
            t = e.getCause();
        } else if (e.getCause() != null && e.getClass().getName().equals(e.getCause().getClass().getName())) {
            t = e.getCause();
        } else {
            return e;
        }
        if (t != null) {
            return Throwables.getRootException(t);
        }
        return e;
    }
}

