/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.groovyx.flow;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.groovyx.flow.ProcessSessionWrap;

public abstract class SessionFile
implements FlowFile {
    FlowFile flowFile;
    ProcessSessionWrap session;

    protected SessionFile(ProcessSessionWrap session, FlowFile f) {
        if (f == null || session == null) {
            throw new NullPointerException("Session and FlowFile are mandatory session=" + String.valueOf(session) + " file=" + String.valueOf(f));
        }
        if (f instanceof SessionFile) {
            throw new RuntimeException("file could be instanceof SessionFile");
        }
        this.flowFile = f;
        this.session = session;
    }

    public ProcessSessionWrap session() {
        return this.session;
    }

    public SessionFile clone(boolean cloneContent) {
        if (cloneContent) {
            return this.session.clone(this.flowFile);
        }
        return this.session.create(this.flowFile);
    }

    public InputStream read() {
        return this.session.read(this.flowFile);
    }

    public void read(InputStreamCallback c) {
        this.session.read(this.flowFile, c);
    }

    public SessionFile write(StreamCallback c) {
        this.session.write((FlowFile)this, c);
        return this;
    }

    public SessionFile write(OutputStreamCallback c) {
        this.session.write((FlowFile)this, c);
        return this;
    }

    public SessionFile append(OutputStreamCallback c) {
        this.session.append(this, c);
        return this;
    }

    public SessionFile putAttribute(String key, String value) {
        this.session.putAttribute(this, key, value);
        return this;
    }

    public SessionFile putAllAttributes(Map<String, String> m) {
        this.session.putAllAttributes((FlowFile)this, (Map)m);
        return this;
    }

    public SessionFile removeAttribute(String key) {
        this.session.removeAttribute(this, key);
        return this;
    }

    public SessionFile removeAllAttributes(Collection<String> keys) {
        Set keySet = keys instanceof Set ? keys : new HashSet(keys);
        this.session.removeAllAttributes((FlowFile)this, keySet);
        return this;
    }

    public void transfer(Relationship r) {
        if (r == null) {
            this.session.transfer(this);
        } else {
            this.session.transfer(this, r);
        }
    }

    public void remove() {
        this.session.remove(this);
    }

    public long getId() {
        return this.flowFile.getId();
    }

    public long getEntryDate() {
        return this.flowFile.getEntryDate();
    }

    public long getLineageStartDate() {
        return this.flowFile.getLineageStartDate();
    }

    public long getLineageStartIndex() {
        return this.flowFile.getLineageStartIndex();
    }

    public Long getLastQueueDate() {
        return this.flowFile.getLastQueueDate();
    }

    public long getQueueDateIndex() {
        return this.flowFile.getQueueDateIndex();
    }

    public boolean isPenalized() {
        return this.flowFile.isPenalized();
    }

    public String getAttribute(String key) {
        return this.flowFile.getAttribute(key);
    }

    public long getSize() {
        return this.flowFile.getSize();
    }

    public Map<String, String> getAttributes() {
        return this.flowFile.getAttributes();
    }

    public int compareTo(FlowFile other) {
        if (other instanceof SessionFile) {
            other = ((SessionFile)other).flowFile;
        }
        return this.flowFile.compareTo((Object)other);
    }

    public String toString() {
        return "WRAP[" + this.flowFile.toString() + "]";
    }
}

