/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.graph;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.graph.GraphClientService;
import org.apache.nifi.graph.GraphQueryResultCallback;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraphFactory;

public class InMemoryJanusGraphClientService
extends AbstractControllerService
implements GraphClientService {
    private Graph graph;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.graph = JanusGraphFactory.build().set("storage.backend", (Object)"inmemory").open();
    }

    public Map<String, String> executeQuery(String query, Map<String, Object> parameters, GraphQueryResultCallback handler) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("groovy");
        parameters.entrySet().forEach(entry -> engine.put((String)entry.getKey(), entry.getValue()));
        engine.put("graph", this.graph);
        engine.put("g", this.graph.traversal());
        try {
            Object response = engine.eval(query);
            if (response instanceof Map) {
                Map resp = (Map)response;
                HashMap result = new HashMap();
                result.put("result", resp.entrySet().iterator().next());
                handler.process(result, false);
            } else {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("result", response);
                handler.process(result, false);
            }
            return new HashMap<String, String>();
        }
        catch (Exception ex) {
            throw new ProcessException((Throwable)ex);
        }
    }

    public String getTransitUrl() {
        return "janusgraph:memory://localhost";
    }

    public Graph getGraph() {
        return this.graph;
    }
}

