/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.vision;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import com.google.cloud.vision.v1.ImageAnnotatorSettings;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.gcp.credentials.service.GCPCredentialsService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.gcp.util.GoogleUtils;

public abstract class AbstractGcpVisionProcessor
extends AbstractProcessor {
    public static final String GCP_OPERATION_KEY = "operationKey";
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to success relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to failure relationship").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE);
    private ImageAnnotatorClient vision;

    protected static List<PropertyDescriptor> getCommonPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        GCPCredentialsService gcpCredentialsService = (GCPCredentialsService)context.getProperty(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE).asControllerService(GCPCredentialsService.class);
        try {
            GoogleCredentials credentials = gcpCredentialsService.getGoogleCredentials();
            FixedCredentialsProvider credentialsProvider = FixedCredentialsProvider.create((Credentials)credentials);
            ImageAnnotatorSettings.Builder builder = (ImageAnnotatorSettings.Builder)ImageAnnotatorSettings.newBuilder().setCredentialsProvider((CredentialsProvider)credentialsProvider);
            this.vision = ImageAnnotatorClient.create((ImageAnnotatorSettings)builder.build());
        }
        catch (Exception e) {
            this.getLogger().error("Failed to create vision client.", (Throwable)e);
            throw new ProcessException("Failed to create vision client.", (Throwable)e);
        }
    }

    protected ImageAnnotatorClient getVisionClient() {
        return this.vision;
    }
}

