/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.storage;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.documentation.UseCase;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.fileresource.service.api.FileResource;
import org.apache.nifi.fileresource.service.api.FileResourceService;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.gcp.credentials.service.GCPCredentialsService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.storage.FetchGCSObject;
import org.apache.nifi.processors.gcp.util.GoogleUtils;

@Tags(value={"file", "resource", "gcs"})
@SeeAlso(value={FetchGCSObject.class})
@CapabilityDescription(value="Provides a Google Compute Storage (GCS) file resource for other components.")
@UseCase(description="Fetch a specific file from GCS. The service provides higher performance compared to fetch processors when the data should be moved between different storages without any transformation.", configuration="\"Bucket\" = \"${gcs.bucket}\"\n\"Name\" = \"${filename}\"\n\nThe \"GCP Credentials Provider Service\" property should specify an instance of the GCPCredentialsService in order to provide credentials for accessing the bucket.\n")
public class GCSFileResourceService
extends AbstractControllerService
implements FileResourceService {
    public static final PropertyDescriptor BUCKET = new PropertyDescriptor.Builder().name("Bucket").description("Bucket of the object.").required(true).defaultValue("${gcs.bucket}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().name("Name").description("Name of the object.").required(true).defaultValue("${" + CoreAttributes.FILENAME.key() + "}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BUCKET, KEY, GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE);
    private volatile PropertyContext context;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.context = context;
    }

    @OnDisabled
    public void onDisabled() {
        this.context = null;
    }

    public FileResource getFileResource(Map<String, String> attributes) {
        GCPCredentialsService gcpCredentialsService = (GCPCredentialsService)this.context.getProperty(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE).asControllerService(GCPCredentialsService.class);
        Storage storage = this.getCloudService(gcpCredentialsService.getGoogleCredentials());
        try {
            return this.fetchBlob(storage, attributes);
        }
        catch (StorageException | IOException e) {
            throw new ProcessException("Failed to fetch GCS Object", e);
        }
    }

    protected Storage getCloudService(GoogleCredentials credentials) {
        StorageOptions storageOptions = ((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)credentials)).build();
        return (Storage)storageOptions.getService();
    }

    private FileResource fetchBlob(Storage storage, Map<String, String> attributes) throws IOException {
        String key;
        String bucketName = this.context.getProperty(BUCKET).evaluateAttributeExpressions(attributes).getValue();
        BlobId blobId = BlobId.of((String)bucketName, (String)(key = this.context.getProperty(KEY).evaluateAttributeExpressions(attributes).getValue()));
        if (blobId.getName() == null || blobId.getName().isEmpty()) {
            throw new IllegalArgumentException("Blob Name is required");
        }
        Blob blob = storage.get(blobId);
        if (blob == null) {
            throw new StorageException(404, "Blob " + String.valueOf(blobId) + " not found");
        }
        ReadChannel reader = storage.reader(blob.getBlobId(), new Storage.BlobSourceOption[0]);
        return new FileResource(Channels.newInputStream((ReadableByteChannel)reader), blob.getSize().longValue());
    }
}

