/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.vision;

import com.google.longrunning.Operation;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.google.rpc.Status;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.vision.AbstractGcpVisionProcessor;

public abstract class AbstractGetGcpVisionAnnotateOperationStatus
extends AbstractGcpVisionProcessor {
    public static final PropertyDescriptor OPERATION_KEY = new PropertyDescriptor.Builder().name("operationKey").displayName("GCP Operation Key").description("The unique identifier of the Vision operation.").defaultValue("${operationKey}").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final Relationship REL_RUNNING = new Relationship.Builder().name("running").description("The job is currently still being processed").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("Upon successful completion, the original FlowFile will be routed to this relationship.").autoTerminateDefault(true).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Stream.concat(AbstractGetGcpVisionAnnotateOperationStatus.getCommonPropertyDescriptors().stream(), Stream.of(OPERATION_KEY)).toList();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_ORIGINAL, REL_SUCCESS, REL_FAILURE, REL_RUNNING);

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            String operationKey = context.getProperty(OPERATION_KEY).evaluateAttributeExpressions(flowFile).getValue();
            Operation operation = this.getVisionClient().getOperationsClient().getOperation(operationKey);
            this.getLogger().info("{}", new Object[]{operation});
            if (operation.getDone() && !operation.hasError()) {
                GeneratedMessageV3 response = this.deserializeResponse(operation.getResponse().getValue());
                FlowFile childFlowFile = session.create(flowFile);
                session.write(childFlowFile, out -> out.write(JsonFormat.printer().print((MessageOrBuilder)response).getBytes(StandardCharsets.UTF_8)));
                session.putAttribute(childFlowFile, CoreAttributes.MIME_TYPE.key(), "application/json");
                session.transfer(flowFile, REL_ORIGINAL);
                session.transfer(childFlowFile, REL_SUCCESS);
            } else if (!operation.getDone()) {
                session.transfer(flowFile, REL_RUNNING);
            } else {
                Status error = operation.getError();
                this.getLogger().error("Failed to execute vision operation. Error code: {}, Error message: {}", new Object[]{error.getCode(), error.getMessage()});
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Fail to get GCP Vision operation's status", (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected abstract GeneratedMessageV3 deserializeResponse(ByteString var1) throws InvalidProtocolBufferException;
}

