/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.storage;

import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.util.StringUtils;

public class StorageAttributes {
    public static final String BUCKET_ATTR = "gcs.bucket";
    public static final String BUCKET_DESC = "Bucket of the object.";
    public static final String KEY_ATTR = "gcs.key";
    public static final String KEY_DESC = "Name of the object.";
    public static final String SIZE_ATTR = "gcs.size";
    public static final String SIZE_DESC = "Size of the object.";
    public static final String CACHE_CONTROL_ATTR = "gcs.cache.control";
    public static final String CACHE_CONTROL_DESC = "Data cache control of the object.";
    public static final String COMPONENT_COUNT_ATTR = "gcs.component.count";
    public static final String COMPONENT_COUNT_DESC = "The number of components which make up the object.";
    public static final String CONTENT_DISPOSITION_ATTR = "gcs.content.disposition";
    public static final String CONTENT_DISPOSITION_DESC = "The data content disposition of the object.";
    public static final String CONTENT_ENCODING_ATTR = "gcs.content.encoding";
    public static final String CONTENT_ENCODING_DESC = "The content encoding of the object.";
    public static final String CONTENT_LANGUAGE_ATTR = "gcs.content.language";
    public static final String CONTENT_LANGUAGE_DESC = "The content language of the object.";
    public static final String CRC32C_ATTR = "gcs.crc32c";
    public static final String CRC32C_DESC = "The CRC32C checksum of object's data, encoded in base64 in big-endian order.";
    public static final String CREATE_TIME_ATTR = "gcs.create.time";
    public static final String CREATE_TIME_DESC = "The creation time of the object (milliseconds)";
    public static final String UPDATE_TIME_ATTR = "gcs.update.time";
    public static final String UPDATE_TIME_DESC = "The last modification time of the object (milliseconds)";
    public static final String ENCRYPTION_ALGORITHM_ATTR = "gcs.encryption.algorithm";
    public static final String ENCRYPTION_ALGORITHM_DESC = "The algorithm used to encrypt the object.";
    public static final String ENCRYPTION_SHA256_ATTR = "gcs.encryption.sha256";
    public static final String ENCRYPTION_SHA256_DESC = "The SHA256 hash of the key used to encrypt the object";
    public static final String ETAG_ATTR = "gcs.etag";
    public static final String ETAG_DESC = "The HTTP 1.1 Entity tag for the object.";
    public static final String GENERATED_ID_ATTR = "gcs.generated.id";
    public static final String GENERATED_ID_DESC = "The service-generated for the object";
    public static final String GENERATION_ATTR = "gcs.generation";
    public static final String GENERATION_DESC = "The data generation of the object.";
    public static final String MD5_ATTR = "gcs.md5";
    public static final String MD5_DESC = "The MD5 hash of the object's data encoded in base64.";
    public static final String MEDIA_LINK_ATTR = "gcs.media.link";
    public static final String MEDIA_LINK_DESC = "The media download link to the object.";
    public static final String METAGENERATION_ATTR = "gcs.metageneration";
    public static final String METAGENERATION_DESC = "The metageneration of the object.";
    public static final String OWNER_ATTR = "gcs.owner";
    public static final String OWNER_DESC = "The owner (uploader) of the object.";
    public static final String OWNER_TYPE_ATTR = "gcs.owner.type";
    public static final String OWNER_TYPE_DESC = "The ACL entity type of the uploader of the object.";
    public static final String URI_ATTR = "gcs.uri";
    public static final String URI_DESC = "The URI of the object as a string.";
    public static final String ACL_OWNER_ATTR = "gcs.acl.owner";
    public static final String ACL_OWNER_DESC = "A comma-delimited list of ACL entities that have owner access to the object. Entities will be either email addresses, domains, or project IDs.";
    public static final String ACL_WRITER_ATTR = "gcs.acl.writer";
    public static final String ACL_WRITER_DESC = "A comma-delimited list of ACL entities that have write access to the object. Entities will be either email addresses, domains, or project IDs.";
    public static final String ACL_READER_ATTR = "gcs.acl.reader";
    public static final String ACL_READER_DESC = "A comma-delimited list of ACL entities that have read access to the object. Entities will be either email addresses, domains, or project IDs.";

    private StorageAttributes() {
    }

    public static Map<String, String> createAttributes(Blob blob) {
        Acl.Entity entity;
        String entityID;
        HashMap<String, String> attributes = new HashMap<String, String>();
        StorageAttributes.addAttribute(attributes, BUCKET_ATTR, blob.getBucket());
        StorageAttributes.addAttribute(attributes, KEY_ATTR, blob.getName());
        StorageAttributes.addAttribute(attributes, SIZE_ATTR, blob.getSize());
        StorageAttributes.addAttribute(attributes, CACHE_CONTROL_ATTR, blob.getCacheControl());
        StorageAttributes.addAttribute(attributes, COMPONENT_COUNT_ATTR, blob.getComponentCount());
        StorageAttributes.addAttribute(attributes, CONTENT_DISPOSITION_ATTR, blob.getContentDisposition());
        StorageAttributes.addAttribute(attributes, CONTENT_ENCODING_ATTR, blob.getContentEncoding());
        StorageAttributes.addAttribute(attributes, CONTENT_LANGUAGE_ATTR, blob.getContentLanguage());
        StorageAttributes.addAttribute(attributes, CoreAttributes.MIME_TYPE.key(), blob.getContentType());
        StorageAttributes.addAttribute(attributes, CRC32C_ATTR, blob.getCrc32c());
        if (blob.getCustomerEncryption() != null) {
            BlobInfo.CustomerEncryption encryption = blob.getCustomerEncryption();
            StorageAttributes.addAttribute(attributes, ENCRYPTION_ALGORITHM_ATTR, encryption.getEncryptionAlgorithm());
            StorageAttributes.addAttribute(attributes, ENCRYPTION_SHA256_ATTR, encryption.getKeySha256());
        }
        StorageAttributes.addAttribute(attributes, ETAG_ATTR, blob.getEtag());
        StorageAttributes.addAttribute(attributes, GENERATED_ID_ATTR, blob.getGeneratedId());
        StorageAttributes.addAttribute(attributes, GENERATION_ATTR, blob.getGeneration());
        StorageAttributes.addAttribute(attributes, MD5_ATTR, blob.getMd5());
        StorageAttributes.addAttribute(attributes, MEDIA_LINK_ATTR, blob.getMediaLink());
        StorageAttributes.addAttribute(attributes, METAGENERATION_ATTR, blob.getMetageneration());
        if (blob.getOwner() != null && (entityID = StorageAttributes.getEntityID(entity = blob.getOwner())) != null) {
            StorageAttributes.addAttribute(attributes, OWNER_ATTR, entityID);
            StorageAttributes.addAttribute(attributes, OWNER_TYPE_ATTR, entity.getType().name().toLowerCase(Locale.ROOT));
        }
        if (blob.getAcl() != null) {
            HashMap aclRoles = new HashMap();
            for (Acl acl : blob.getAcl()) {
                String entityID2;
                Acl.Role role = acl.getRole();
                if (!aclRoles.containsKey(role)) {
                    aclRoles.put(role, new ArrayList());
                }
                if ((entityID2 = StorageAttributes.getEntityID(acl.getEntity())) == null) continue;
                ((List)aclRoles.get(role)).add(entityID2);
            }
            for (Map.Entry entry : aclRoles.entrySet()) {
                String entities = StringUtils.join((Collection)((Collection)entry.getValue()), (String)",");
                if (((Acl.Role)entry.getKey()).equals((Object)Acl.Role.OWNER)) {
                    StorageAttributes.addAttribute(attributes, ACL_OWNER_ATTR, entities);
                    continue;
                }
                if (((Acl.Role)entry.getKey()).equals((Object)Acl.Role.WRITER)) {
                    StorageAttributes.addAttribute(attributes, ACL_WRITER_ATTR, entities);
                    continue;
                }
                if (!((Acl.Role)entry.getKey()).equals((Object)Acl.Role.READER)) continue;
                StorageAttributes.addAttribute(attributes, ACL_READER_ATTR, entities);
            }
        }
        StorageAttributes.addAttribute(attributes, URI_ATTR, blob.getSelfLink());
        StorageAttributes.addAttribute(attributes, CoreAttributes.FILENAME.key(), blob.getName());
        StorageAttributes.addAttribute(attributes, CREATE_TIME_ATTR, blob.getCreateTimeOffsetDateTime().toInstant().toEpochMilli());
        StorageAttributes.addAttribute(attributes, UPDATE_TIME_ATTR, blob.getUpdateTimeOffsetDateTime().toInstant().toEpochMilli());
        return attributes;
    }

    private static String getEntityID(Acl.Entity entity) {
        return switch (entity.getType()) {
            default -> throw new MatchException(null, null);
            case Acl.Entity.Type.DOMAIN -> ((Acl.Domain)entity).getDomain();
            case Acl.Entity.Type.GROUP -> ((Acl.Group)entity).getEmail();
            case Acl.Entity.Type.USER -> ((Acl.User)entity).getEmail();
            case Acl.Entity.Type.PROJECT -> ((Acl.Project)entity).getProjectId();
            case Acl.Entity.Type.UNKNOWN -> null;
        };
    }

    private static void addAttribute(Map<String, String> attributes, String key, Object value) {
        if (value == null) {
            return;
        }
        attributes.put(key, value.toString());
    }

    private static void addAttribute(Map<String, String> attributes, String key, String value) {
        if (value == null) {
            return;
        }
        attributes.put(key, value);
    }
}

