/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.ProtocolHandler;
import org.apache.nifi.cluster.protocol.ProtocolListener;
import org.apache.nifi.cluster.protocol.UnknownServiceAddressException;
import org.apache.nifi.cluster.protocol.message.ClusterWorkloadRequestMessage;
import org.apache.nifi.cluster.protocol.message.ClusterWorkloadResponseMessage;
import org.apache.nifi.cluster.protocol.message.ConnectionRequestMessage;
import org.apache.nifi.cluster.protocol.message.ConnectionResponseMessage;
import org.apache.nifi.cluster.protocol.message.HeartbeatMessage;
import org.apache.nifi.cluster.protocol.message.HeartbeatResponseMessage;
import org.apache.nifi.cluster.protocol.message.NodeStatusesRequestMessage;
import org.apache.nifi.cluster.protocol.message.NodeStatusesResponseMessage;
import org.apache.nifi.reporting.BulletinRepository;

public class NodeProtocolSenderListener
implements NodeProtocolSender,
ProtocolListener {
    private final NodeProtocolSender sender;
    private final ProtocolListener listener;

    public NodeProtocolSenderListener(NodeProtocolSender sender, ProtocolListener listener) {
        if (sender == null) {
            throw new IllegalArgumentException("NodeProtocolSender may not be null.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("ProtocolListener may not be null.");
        }
        this.sender = sender;
        this.listener = listener;
    }

    @Override
    public void stop() throws IOException {
        if (!this.isRunning()) {
            return;
        }
        this.listener.stop();
    }

    @Override
    public void start() throws IOException {
        if (this.isRunning()) {
            return;
        }
        this.listener.start();
    }

    @Override
    public boolean isRunning() {
        return this.listener.isRunning();
    }

    @Override
    public boolean removeHandler(ProtocolHandler handler) {
        return this.listener.removeHandler(handler);
    }

    @Override
    public Collection<ProtocolHandler> getHandlers() {
        return this.listener.getHandlers();
    }

    @Override
    public void addHandler(ProtocolHandler handler) {
        this.listener.addHandler(handler);
    }

    @Override
    public ConnectionResponseMessage requestConnection(ConnectionRequestMessage msg, boolean allowConnectToSelf) throws ProtocolException, UnknownServiceAddressException {
        return this.sender.requestConnection(msg, allowConnectToSelf);
    }

    @Override
    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.listener.setBulletinRepository(bulletinRepository);
    }

    @Override
    public HeartbeatResponseMessage heartbeat(HeartbeatMessage msg, String address) throws ProtocolException {
        return this.sender.heartbeat(msg, address);
    }

    @Override
    public ClusterWorkloadResponseMessage clusterWorkload(ClusterWorkloadRequestMessage msg) throws ProtocolException {
        return this.sender.clusterWorkload(msg);
    }

    @Override
    public NodeStatusesResponseMessage nodeStatuses(NodeStatusesRequestMessage msg) throws ProtocolException {
        return this.sender.nodeStatuses(msg);
    }
}

