/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.resource;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.user.NiFiUser;

public interface Authorizable {
    public Authorizable getParentAuthorizable();

    public Resource getResource();

    default public boolean isAuthorized(Authorizer authorizer, RequestAction action, NiFiUser user) {
        return AuthorizationResult.Result.Approved.equals((Object)this.checkAuthorization(authorizer, action, user).getResult());
    }

    default public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        HashMap<String, String> userContext;
        if (user == null) {
            return AuthorizationResult.denied("Unknown user");
        }
        if (user.getClientAddress() != null && !user.getClientAddress().trim().isEmpty()) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        AuthorizationRequest request = new AuthorizationRequest.Builder().identity(user.getIdentity()).anonymous(user.isAnonymous()).accessAttempt(false).action(action).resource(this.getResource()).resourceContext(resourceContext).userContext(userContext).build();
        AuthorizationResult result = authorizer.authorize(request);
        if (AuthorizationResult.Result.ResourceNotFound.equals((Object)result.getResult())) {
            Authorizable parent = this.getParentAuthorizable();
            if (parent == null) {
                return AuthorizationResult.denied();
            }
            return parent.checkAuthorization(authorizer, action, user, resourceContext);
        }
        return result;
    }

    default public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user) {
        return this.checkAuthorization(authorizer, action, user, null);
    }

    default public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        HashMap<String, String> userContext;
        if (user == null) {
            throw new AccessDeniedException("Unknown user");
        }
        if (user.getClientAddress() != null && !user.getClientAddress().trim().isEmpty()) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        AuthorizationRequest request = new AuthorizationRequest.Builder().identity(user.getIdentity()).anonymous(user.isAnonymous()).accessAttempt(true).action(action).resource(this.getResource()).resourceContext(resourceContext).userContext(userContext).build();
        AuthorizationResult result = authorizer.authorize(request);
        if (AuthorizationResult.Result.ResourceNotFound.equals((Object)result.getResult())) {
            Authorizable parent = this.getParentAuthorizable();
            if (parent == null) {
                throw new AccessDeniedException("Access is denied");
            }
            parent.authorize(authorizer, action, user, resourceContext);
        } else if (AuthorizationResult.Result.Denied.equals((Object)result.getResult())) {
            throw new AccessDeniedException(result.getExplanation());
        }
    }

    default public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user) throws AccessDeniedException {
        this.authorize(authorizer, action, user, null);
    }
}

